/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-01-19 02:35:23 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `manl_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_countries` (
  `ID` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `alpha2Code` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `alpha3Code` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `callingCodes` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `capital` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `region` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subregion` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `population` bigint(20) DEFAULT NULL,
  `latlng` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `demonym` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `timezones` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency_name` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency_code` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency_symbol` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `flag` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_format` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_geodir_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_attachments` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `date_gmt` datetime DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `other_id` int(11) DEFAULT NULL,
  `title` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `caption` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `file` varchar(254) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mime_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '1',
  `metadata` text COLLATE utf8mb4_unicode_520_ci,
  `type` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT 'post_images',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_business_hours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) DEFAULT NULL,
  `open` int(11) DEFAULT NULL,
  `close` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_type` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `field_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'text,checkbox,radio,select,textarea',
  `field_type_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `admin_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `frontend_desc` text COLLATE utf8mb4_unicode_520_ci,
  `frontend_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `htmlvar_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `default_value` text COLLATE utf8mb4_unicode_520_ci,
  `placeholder_value` text COLLATE utf8mb4_unicode_520_ci,
  `sort_order` int(11) NOT NULL,
  `tab_parent` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `tab_level` int(11) NOT NULL DEFAULT '0',
  `option_values` text COLLATE utf8mb4_unicode_520_ci,
  `clabels` text COLLATE utf8mb4_unicode_520_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `required_msg` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `show_in` text COLLATE utf8mb4_unicode_520_ci,
  `for_admin_use` tinyint(1) NOT NULL DEFAULT '0',
  `packages` text COLLATE utf8mb4_unicode_520_ci,
  `cat_sort` text COLLATE utf8mb4_unicode_520_ci,
  `cat_filter` text COLLATE utf8mb4_unicode_520_ci,
  `extra_fields` text COLLATE utf8mb4_unicode_520_ci,
  `field_icon` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `decimal_point` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `validation_pattern` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `validation_msg` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_custom_sort_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `frontend_title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `htmlvar_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sort_order` int(11) NOT NULL,
  `tab_parent` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `tab_level` int(11) NOT NULL DEFAULT '0',
  `is_active` int(11) NOT NULL,
  `is_default` int(11) NOT NULL,
  `sort` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT 'asc',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_gd_place_detail` (
  `post_id` int(11) NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_tags` text COLLATE utf8mb4_unicode_520_ci,
  `post_category` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `default_category` int(11) DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_image` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submit_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `overall_rating` float DEFAULT '0',
  `rating_count` int(11) DEFAULT '0',
  `street` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `street2` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `zip` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `latitude` varchar(22) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `longitude` varchar(22) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mapview` varchar(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mapzoom` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_dummy` tinyint(1) DEFAULT '0',
  `phone` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(254) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `website` text COLLATE utf8mb4_unicode_520_ci,
  `twitter` text COLLATE utf8mb4_unicode_520_ci,
  `facebook` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`post_id`),
  KEY `country` (`country`),
  KEY `region` (`region`),
  KEY `city` (`city`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_post_review` (
  `comment_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) DEFAULT '0',
  `user_id` bigint(20) DEFAULT '0',
  `rating` float DEFAULT '0',
  `ratings` text COLLATE utf8mb4_unicode_520_ci,
  `attachments` text COLLATE utf8mb4_unicode_520_ci,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `city` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `region` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `country` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `latitude` varchar(22) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `longitude` varchar(22) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  UNIQUE KEY `comment_id` (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_geodir_tabs_layout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_type` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL,
  `tab_layout` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_parent` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_level` int(11) NOT NULL,
  `tab_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_icon` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tab_content` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_lana_downloads_manager_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `user_ip` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `download_id` bigint(20) NOT NULL,
  `download_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_name` (`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) NOT NULL,
  `msg` varchar(255) NOT NULL,
  `l_added` datetime NOT NULL,
  `l_status` enum('success','failed','blocked') NOT NULL,
  `l_type` enum('new','old') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=19952 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2007 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `manl_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `manl_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `manl_swpm_members_tbl` (
  `member_id` int(12) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `first_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `last_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `member_since` date NOT NULL DEFAULT '0000-00-00',
  `membership_level` smallint(6) NOT NULL,
  `more_membership_levels` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `account_state` enum('active','inactive','activation_required','expired','pending','unsubscribed') COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed_from_ip` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_street` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_city` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_state` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_zipcode` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `home_page` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `gender` enum('male','female','not specified') COLLATE utf8mb4_unicode_520_ci DEFAULT 'not specified',
  `referrer` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `extra_info` text COLLATE utf8mb4_unicode_520_ci,
  `reg_code` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subscription_starts` date DEFAULT NULL,
  `initial_membership_level` smallint(6) DEFAULT NULL,
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `subscr_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `company_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `flags` int(11) DEFAULT '0',
  `profile_image` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`member_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_swpm_membership_meta_tbl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_id` int(11) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `meta_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'text',
  `meta_default` text COLLATE utf8mb4_unicode_520_ci,
  `meta_context` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`),
  KEY `level_id` (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_swpm_membership_tbl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` varchar(127) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `role` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscriber',
  `permissions` tinyint(4) NOT NULL DEFAULT '0',
  `subscription_period` varchar(11) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '-1',
  `subscription_duration_type` tinyint(4) NOT NULL DEFAULT '0',
  `subscription_unit` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `loginredirect_page` text COLLATE utf8mb4_unicode_520_ci,
  `category_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `page_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `post_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `comment_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `attachment_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `custom_post_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `disable_bookmark_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `protect_older_posts` tinyint(1) NOT NULL DEFAULT '0',
  `campaign_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_swpm_payments_tbl` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `last_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `member_id` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `membership_level` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `txn_date` date NOT NULL DEFAULT '0000-00-00',
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscr_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reference` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `payment_amount` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `gateway` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `status` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `ip_address` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(10,2) DEFAULT NULL,
  `max_price` decimal(10,2) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=2604 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7299 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=35867 DEFAULT CHARSET=utf8;

CREATE TABLE `manl_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `manl_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wpfd_statistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `related_id` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `related_id` (`related_id`),
  KEY `uid` (`uid`),
  KEY `type` (`type`),
  KEY `date` (`date`),
  KEY `count` (`count`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `manl_wpfd_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=448 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: manl_commentmeta */
INSERT INTO `manl_commentmeta` VALUES("1", "3", "akismet_error", "1370606225");
INSERT INTO `manl_commentmeta` VALUES("2", "3", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("3", "3", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("4", "3", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("5", "3", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("6", "3", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("7", "4", "akismet_error", "1370606029");
INSERT INTO `manl_commentmeta` VALUES("8", "4", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("9", "4", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("10", "4", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("11", "4", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("12", "4", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("13", "5", "akismet_error", "1370606265");
INSERT INTO `manl_commentmeta` VALUES("14", "5", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("15", "5", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("16", "5", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("17", "5", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("18", "5", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("19", "6", "akismet_error", "1370605393");
INSERT INTO `manl_commentmeta` VALUES("20", "6", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("21", "6", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("22", "6", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("23", "6", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("24", "6", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("25", "7", "akismet_error", "1370606115");
INSERT INTO `manl_commentmeta` VALUES("26", "7", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("27", "7", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("28", "7", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("29", "7", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("30", "7", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("31", "8", "akismet_error", "1370610134");
INSERT INTO `manl_commentmeta` VALUES("32", "8", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("33", "8", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("34", "8", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("35", "8", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("36", "8", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("37", "9", "akismet_error", "1370606072");
INSERT INTO `manl_commentmeta` VALUES("38", "9", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("39", "9", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("40", "9", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("41", "9", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("42", "9", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("43", "10", "akismet_error", "1370610085");
INSERT INTO `manl_commentmeta` VALUES("44", "10", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("45", "10", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("46", "10", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("47", "10", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("48", "10", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("49", "11", "akismet_error", "1370620193");
INSERT INTO `manl_commentmeta` VALUES("50", "11", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("51", "11", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("52", "11", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("53", "11", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("54", "11", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("55", "12", "akismet_error", "1370610209");
INSERT INTO `manl_commentmeta` VALUES("56", "12", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("57", "12", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("58", "12", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("59", "12", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("60", "12", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("61", "13", "akismet_error", "1370611492");
INSERT INTO `manl_commentmeta` VALUES("62", "13", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("63", "13", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("64", "13", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("65", "13", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("66", "13", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("67", "14", "akismet_error", "1370620411");
INSERT INTO `manl_commentmeta` VALUES("68", "14", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("69", "14", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("70", "14", "rating", "3");
INSERT INTO `manl_commentmeta` VALUES("71", "14", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("72", "14", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("73", "15", "akismet_error", "1370606279");
INSERT INTO `manl_commentmeta` VALUES("74", "15", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("75", "15", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("76", "15", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("77", "15", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("78", "16", "akismet_error", "1370620393");
INSERT INTO `manl_commentmeta` VALUES("79", "16", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("80", "16", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("81", "16", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("82", "16", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("83", "17", "akismet_error", "1370605612");
INSERT INTO `manl_commentmeta` VALUES("84", "17", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("85", "17", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("86", "17", "rating", "4");
INSERT INTO `manl_commentmeta` VALUES("87", "17", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("88", "17", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("89", "18", "akismet_error", "1370605993");
INSERT INTO `manl_commentmeta` VALUES("90", "18", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("91", "18", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("92", "18", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("93", "18", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("94", "18", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("95", "19", "akismet_error", "1370606643");
INSERT INTO `manl_commentmeta` VALUES("96", "19", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("97", "19", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("98", "19", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("99", "19", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("100", "19", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("101", "20", "akismet_error", "1370606091");
INSERT INTO `manl_commentmeta` VALUES("102", "20", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("103", "20", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("104", "20", "rating", "1");
INSERT INTO `manl_commentmeta` VALUES("105", "20", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("106", "20", "verified", "0");
INSERT INTO `manl_commentmeta` VALUES("107", "21", "akismet_error", "1370620222");
INSERT INTO `manl_commentmeta` VALUES("108", "21", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("109", "21", "akismet_as_submitted", "");
INSERT INTO `manl_commentmeta` VALUES("110", "21", "rating", "5");
INSERT INTO `manl_commentmeta` VALUES("111", "21", "akismet_history", "");
INSERT INTO `manl_commentmeta` VALUES("112", "21", "verified", "0");

/* INSERT TABLE DATA: manl_comments */
INSERT INTO `manl_comments` VALUES("3", "575", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:05", "2013-06-07 11:57:05", "Simple and effective design. One of my favorites.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("4", "576", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:49", "2013-06-07 11:53:49", "Wonderful quality, and an awesome design. WooThemes ftw!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("5", "576", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:57:45", "2013-06-07 11:57:45", "This t-shirt is awesome! Would recommend to everyone!\n\nI\'m ordering mine next week", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("6", "577", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:43:13", "2013-06-07 11:43:13", "Nice T-shirt, I got one in black. Goes with anything!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("7", "577", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:55:15", "2013-06-07 11:55:15", "Very comfortable shirt, and I love the graphic!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("8", "577", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:02:14", "2013-06-07 13:02:14", "Great T-shirt quality, Great Design and Great Service.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("9", "578", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:54:32", "2013-06-07 11:54:32", "The ninja silhouette is one of my favorite designs. This is a great product.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("10", "580", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:01:25", "2013-06-07 13:01:25", "This will go great with my Hoodie that I ordered a few weeks ago.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("11", "580", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:49:53", "2013-06-07 15:49:53", "Love this shirt! The ninja near and dear to my heart. &lt;3", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("12", "581", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:03:29", "2013-06-07 13:03:29", "Another great quality product that anyone who see\'s me wearing has asked where to purchase one of their own.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("13", "581", "Ryan", "ryan@woothemes.com", "", "99.153.225.252", "2013-06-07 13:24:52", "2013-06-07 13:24:52", "This hoodie gets me lots of looks while out in public, I got the blue one and it\'s awesome. Not sure if people are looking at my hoodie only, or also at my rocking bod.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("14", "581", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:31", "2013-06-07 15:53:31", "Ship it!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("15", "582", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:59", "2013-06-07 11:57:59", "This hoodie is great for those chilly winter days. I love the WooNinja!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("16", "582", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:13", "2013-06-07 15:53:13", "Perfect for the lady Ninja in your life!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("17", "583", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:46:52", "2013-06-07 11:46:52", "Perfect when you\'re sat at your computer, waiting for the next batch of Woo Goodies to be released. The Patient Ninja is Patient.", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("18", "583", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:13", "2013-06-07 11:53:13", "The most comfortable hoodie I have ever owned!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("19", "583", "Magnus", "magnus@woothemes.com", "", "79.161.106.35", "2013-06-07 12:04:03", "2013-06-07 12:04:03", "This is my favorite hoodie!\n\nIf only it came in red as well!", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("20", "584", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:54:51", "2013-06-07 11:54:51", "I bought this thinking it was a nice green colour, apparently it GREY! I\'m colour blind so I don\'t care but my girlfriend says grey makes me look fat", "0", "1", "", "comment", "0", "0");
INSERT INTO `manl_comments` VALUES("21", "584", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:50:22", "2013-06-07 15:50:22", "I love grey hoodies! This is perfect with my grey Ninja shirt, when I get cold I throw this on and I can still be a Ninja.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: manl_countries */
INSERT INTO `manl_countries` VALUES("1", "Afghanistan", "afghanistan", "AF", "AFG", "93", "Kabul", "Asia", "Southern Asia", "27657145", "33,65", "Afghan", "UTC+04:30", "Afghan afghani", "AFN", "؋", "https://restcountries.eu/data/afg.svg", "");
INSERT INTO `manl_countries` VALUES("2", "Åland Islands", "aland-islands", "AX", "ALA", "358", "Mariehamn", "Europe", "Northern Europe", "28875", "60.116667,19.9", "Ålandish", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/ala.svg", "");
INSERT INTO `manl_countries` VALUES("3", "Albania", "albania", "AL", "ALB", "355", "Tirana", "Europe", "Southern Europe", "2886026", "41,20", "Albanian", "UTC+01:00", "Albanian lek", "ALL", "L", "https://restcountries.eu/data/alb.svg", "");
INSERT INTO `manl_countries` VALUES("4", "Algeria", "algeria", "DZ", "DZA", "213", "Algiers", "Africa", "Northern Africa", "40400000", "28,3", "Algerian", "UTC+01:00", "Algerian dinar", "DZD", "د.ج", "https://restcountries.eu/data/dza.svg", "");
INSERT INTO `manl_countries` VALUES("5", "American Samoa", "american-samoa", "AS", "ASM", "1684", "Pago Pago", "Oceania", "Polynesia", "57100", "-14.33333333,-170", "American Samoan", "UTC-11:00", "United State Dollar", "USD", "$", "https://restcountries.eu/data/asm.svg", "");
INSERT INTO `manl_countries` VALUES("6", "Andorra", "andorra", "AD", "AND", "376", "Andorra la Vella", "Europe", "Southern Europe", "78014", "42.5,1.5", "Andorran", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/and.svg", "");
INSERT INTO `manl_countries` VALUES("7", "Angola", "angola", "AO", "AGO", "244", "Luanda", "Africa", "Middle Africa", "25868000", "-12.5,18.5", "Angolan", "UTC+01:00", "Angolan kwanza", "AOA", "Kz", "https://restcountries.eu/data/ago.svg", "");
INSERT INTO `manl_countries` VALUES("8", "Anguilla", "anguilla", "AI", "AIA", "1264", "The Valley", "Americas", "Caribbean", "13452", "18.25,-63.16666666", "Anguillian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/aia.svg", "");
INSERT INTO `manl_countries` VALUES("9", "Antarctica", "antarctica", "AQ", "ATA", "672", "", "Polar", "", "1000", "-74.65,4.48", "", "UTC-03:00,UTC+03:00,UTC+05:00,UTC+06:00,UTC+07:00,UTC+08:00,UTC+10:00,UTC+12:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/ata.svg", "");
INSERT INTO `manl_countries` VALUES("10", "Antigua and Barbuda", "antigua-and-barbuda", "AG", "ATG", "1268", "Saint John\'s", "Americas", "Caribbean", "86295", "17.05,-61.8", "Antiguan, Barbudan", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/atg.svg", "");
INSERT INTO `manl_countries` VALUES("11", "Argentina", "argentina", "AR", "ARG", "54", "Buenos Aires", "Americas", "South America", "43590400", "-34,-64", "Argentinean", "UTC-03:00", "Argentine peso", "ARS", "$", "https://restcountries.eu/data/arg.svg", "");
INSERT INTO `manl_countries` VALUES("12", "Armenia", "armenia", "AM", "ARM", "374", "Yerevan", "Asia", "Western Asia", "2994400", "40,45", "Armenian", "UTC+04:00", "Armenian dram", "AMD", "", "https://restcountries.eu/data/arm.svg", "");
INSERT INTO `manl_countries` VALUES("13", "Aruba", "aruba", "AW", "ABW", "297", "Oranjestad", "Americas", "Caribbean", "107394", "12.5,-69.96666666", "Aruban", "UTC-04:00", "Aruban florin", "AWG", "ƒ", "https://restcountries.eu/data/abw.svg", "");
INSERT INTO `manl_countries` VALUES("14", "Australia", "australia", "AU", "AUS", "61", "Canberra", "Oceania", "Australia and New Zealand", "24117360", "-27,133", "Australian", "UTC+05:00,UTC+06:30,UTC+07:00,UTC+08:00,UTC+09:30,UTC+10:00,UTC+10:30,UTC+11:30", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/aus.svg", "");
INSERT INTO `manl_countries` VALUES("15", "Austria", "austria", "AT", "AUT", "43", "Vienna", "Europe", "Western Europe", "8725931", "47.33333333,13.33333333", "Austrian", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/aut.svg", "");
INSERT INTO `manl_countries` VALUES("16", "Azerbaijan", "azerbaijan", "AZ", "AZE", "994", "Baku", "Asia", "Western Asia", "9730500", "40.5,47.5", "Azerbaijani", "UTC+04:00", "Azerbaijani manat", "AZN", "", "https://restcountries.eu/data/aze.svg", "");
INSERT INTO `manl_countries` VALUES("17", "Bahamas", "bahamas", "BS", "BHS", "1242", "Nassau", "Americas", "Caribbean", "378040", "24.25,-76", "Bahamian", "UTC-05:00", "Bahamian dollar", "BSD", "$", "https://restcountries.eu/data/bhs.svg", "");
INSERT INTO `manl_countries` VALUES("18", "Bahrain", "bahrain", "BH", "BHR", "973", "Manama", "Asia", "Western Asia", "1404900", "26,50.55", "Bahraini", "UTC+03:00", "Bahraini dinar", "BHD", ".د.", "https://restcountries.eu/data/bhr.svg", "");
INSERT INTO `manl_countries` VALUES("19", "Bangladesh", "bangladesh", "BD", "BGD", "880", "Dhaka", "Asia", "Southern Asia", "161006790", "24,90", "Bangladeshi", "UTC+06:00", "Bangladeshi taka", "BDT", "৳", "https://restcountries.eu/data/bgd.svg", "");
INSERT INTO `manl_countries` VALUES("20", "Barbados", "barbados", "BB", "BRB", "1246", "Bridgetown", "Americas", "Caribbean", "285000", "13.16666666,-59.53333333", "Barbadian", "UTC-04:00", "Barbadian dollar", "BBD", "$", "https://restcountries.eu/data/brb.svg", "");
INSERT INTO `manl_countries` VALUES("21", "Belarus", "belarus", "BY", "BLR", "375", "Minsk", "Europe", "Eastern Europe", "9498700", "53,28", "Belarusian", "UTC+03:00", "New Belarusian ruble", "BYN", "Br", "https://restcountries.eu/data/blr.svg", "");
INSERT INTO `manl_countries` VALUES("22", "Belgium", "belgium", "BE", "BEL", "32", "Brussels", "Europe", "Western Europe", "11319511", "50.83333333,4", "Belgian", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/bel.svg", "");
INSERT INTO `manl_countries` VALUES("23", "Belize", "belize", "BZ", "BLZ", "501", "Belmopan", "Americas", "Central America", "370300", "17.25,-88.75", "Belizean", "UTC-06:00", "Belize dollar", "BZD", "$", "https://restcountries.eu/data/blz.svg", "");
INSERT INTO `manl_countries` VALUES("24", "Benin", "benin", "BJ", "BEN", "229", "Porto-Novo", "Africa", "Western Africa", "10653654", "9.5,2.25", "Beninese", "UTC+01:00", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/ben.svg", "");
INSERT INTO `manl_countries` VALUES("25", "Bermuda", "bermuda", "BM", "BMU", "1441", "Hamilton", "Americas", "Northern America", "61954", "32.33333333,-64.75", "Bermudian", "UTC-04:00", "Bermudian dollar", "BMD", "$", "https://restcountries.eu/data/bmu.svg", "");
INSERT INTO `manl_countries` VALUES("26", "Bhutan", "bhutan", "BT", "BTN", "975", "Thimphu", "Asia", "Southern Asia", "775620", "27.5,90.5", "Bhutanese", "UTC+06:00", "Bhutanese ngultrum", "BTN", "Nu.", "https://restcountries.eu/data/btn.svg", "");
INSERT INTO `manl_countries` VALUES("27", "Bolivia", "bolivia", "BO", "BOL", "591", "Sucre", "Americas", "South America", "10985059", "-17,-65", "Bolivian", "UTC-04:00", "Bolivian boliviano", "BOB", "Bs.", "https://restcountries.eu/data/bol.svg", "");
INSERT INTO `manl_countries` VALUES("28", "Bonaire, Sint Eustatius and Saba", "bonaire-sint-eustatius-and-saba", "BQ", "BES", "5997", "Kralendijk", "Americas", "Caribbean", "17408", "12.15,-68.266667", "Dutch", "UTC-04:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/bes.svg", "");
INSERT INTO `manl_countries` VALUES("29", "Bosnia and Herzegovina", "bosnia-and-herzegovina", "BA", "BIH", "387", "Sarajevo", "Europe", "Southern Europe", "3531159", "44,18", "Bosnian, Herzegovinian", "UTC+01:00", "Bosnia and Herzegovina convertible mark", "BAM", "", "https://restcountries.eu/data/bih.svg", "");
INSERT INTO `manl_countries` VALUES("30", "Botswana", "botswana", "BW", "BWA", "267", "Gaborone", "Africa", "Southern Africa", "2141206", "-22,24", "Motswana", "UTC+02:00", "Botswana pula", "BWP", "P", "https://restcountries.eu/data/bwa.svg", "");
INSERT INTO `manl_countries` VALUES("31", "Bouvet Island", "bouvet-island", "BV", "BVT", "", "", "", "", "0", "-54.43333333,3.4", "", "UTC+01:00", "Norwegian krone", "NOK", "kr", "https://restcountries.eu/data/bvt.svg", "");
INSERT INTO `manl_countries` VALUES("32", "Brazil", "brazil", "BR", "BRA", "55", "Brasília", "Americas", "South America", "206135893", "-10,-55", "Brazilian", "UTC-05:00,UTC-04:00,UTC-03:00,UTC-02:00", "Brazilian real", "BRL", "R$", "https://restcountries.eu/data/bra.svg", "");
INSERT INTO `manl_countries` VALUES("33", "British Indian Ocean Territory", "british-indian-ocean-territory", "IO", "IOT", "246", "Diego Garcia", "Africa", "Eastern Africa", "3000", "-6,71.5", "Indian", "UTC+06:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/iot.svg", "");
INSERT INTO `manl_countries` VALUES("34", "United States Minor Outlying Islands", "united-states-minor-outlying-islands", "UM", "UMI", "", "", "Americas", "Northern America", "300", "", "American", "UTC-11:00,UTC-10:00,UTC+12:00", "United States Dollar", "USD", "$", "https://restcountries.eu/data/umi.svg", "");
INSERT INTO `manl_countries` VALUES("35", "British Virgin Islands", "british-virgin-islands", "VG", "VGB", "1284", "Road Town", "Americas", "Caribbean", "28514", "18.431383,-64.62305", "Virgin Islander", "UTC-04:00", "[D]", "", "$", "https://restcountries.eu/data/vgb.svg", "");
INSERT INTO `manl_countries` VALUES("36", "US Virgin Islands", "us-virgin-islands", "VI", "VIR", "1 340", "Charlotte Amalie", "Americas", "Caribbean", "114743", "18.34,-64.93", "Virgin Islander", "UTC-04:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/vir.svg", "");
INSERT INTO `manl_countries` VALUES("37", "Brunei Darussalam", "brunei-darussalam", "BN", "BRN", "673", "Bandar Seri Begawan", "Asia", "South-Eastern Asia", "411900", "4.5,114.66666666", "Bruneian", "UTC+08:00", "Brunei dollar", "BND", "$", "https://restcountries.eu/data/brn.svg", "");
INSERT INTO `manl_countries` VALUES("38", "Bulgaria", "bulgaria", "BG", "BGR", "359", "Sofia", "Europe", "Eastern Europe", "7153784", "43,25", "Bulgarian", "UTC+02:00", "Bulgarian lev", "BGN", "лв", "https://restcountries.eu/data/bgr.svg", "");
INSERT INTO `manl_countries` VALUES("39", "Burkina Faso", "burkina-faso", "BF", "BFA", "226", "Ouagadougou", "Africa", "Western Africa", "19034397", "13,-2", "Burkinabe", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/bfa.svg", "");
INSERT INTO `manl_countries` VALUES("40", "Burundi", "burundi", "BI", "BDI", "257", "Bujumbura", "Africa", "Eastern Africa", "10114505", "-3.5,30", "Burundian", "UTC+02:00", "Burundian franc", "BIF", "Fr", "https://restcountries.eu/data/bdi.svg", "");
INSERT INTO `manl_countries` VALUES("41", "Cambodia", "cambodia", "KH", "KHM", "855", "Phnom Penh", "Asia", "South-Eastern Asia", "15626444", "13,105", "Cambodian", "UTC+07:00", "Cambodian riel", "KHR", "៛", "https://restcountries.eu/data/khm.svg", "");
INSERT INTO `manl_countries` VALUES("42", "Cameroon", "cameroon", "CM", "CMR", "237", "Yaoundé", "Africa", "Middle Africa", "22709892", "6,12", "Cameroonian", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/cmr.svg", "");
INSERT INTO `manl_countries` VALUES("43", "Canada", "canada", "CA", "CAN", "1", "Ottawa", "Americas", "Northern America", "36155487", "60,-95", "Canadian", "UTC-08:00,UTC-07:00,UTC-06:00,UTC-05:00,UTC-04:00,UTC-03:30", "Canadian dollar", "CAD", "$", "https://restcountries.eu/data/can.svg", "");
INSERT INTO `manl_countries` VALUES("44", "Cabo Verde", "cabo-verde", "CV", "CPV", "238", "Praia", "Africa", "Western Africa", "531239", "16,-24", "Cape Verdian", "UTC-01:00", "Cape Verdean escudo", "CVE", "Esc", "https://restcountries.eu/data/cpv.svg", "");
INSERT INTO `manl_countries` VALUES("45", "Cayman Islands", "cayman-islands", "KY", "CYM", "1345", "George Town", "Americas", "Caribbean", "58238", "19.5,-80.5", "Caymanian", "UTC-05:00", "Cayman Islands dollar", "KYD", "$", "https://restcountries.eu/data/cym.svg", "");
INSERT INTO `manl_countries` VALUES("46", "Central African Republic", "central-african-republic", "CF", "CAF", "236", "Bangui", "Africa", "Middle Africa", "4998000", "7,21", "Central African", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/caf.svg", "");
INSERT INTO `manl_countries` VALUES("47", "Chad", "chad", "TD", "TCD", "235", "N\'Djamena", "Africa", "Middle Africa", "14497000", "15,19", "Chadian", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/tcd.svg", "");
INSERT INTO `manl_countries` VALUES("48", "Chile", "chile", "CL", "CHL", "56", "Santiago", "Americas", "South America", "18191900", "-30,-71", "Chilean", "UTC-06:00,UTC-04:00", "Chilean peso", "CLP", "$", "https://restcountries.eu/data/chl.svg", "");
INSERT INTO `manl_countries` VALUES("49", "China", "china", "CN", "CHN", "86", "Beijing", "Asia", "Eastern Asia", "1377422166", "35,105", "Chinese", "UTC+08:00", "Chinese yuan", "CNY", "¥", "https://restcountries.eu/data/chn.svg", "");
INSERT INTO `manl_countries` VALUES("50", "Christmas Island", "christmas-island", "CX", "CXR", "61", "Flying Fish Cove", "Oceania", "Australia and New Zealand", "2072", "-10.5,105.66666666", "Christmas Island", "UTC+07:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/cxr.svg", "");
INSERT INTO `manl_countries` VALUES("51", "Cocos (Keeling) Islands", "cocos-keeling-islands", "CC", "CCK", "61", "West Island", "Oceania", "Australia and New Zealand", "550", "-12.5,96.83333333", "Cocos Islander", "UTC+06:30", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/cck.svg", "");
INSERT INTO `manl_countries` VALUES("52", "Colombia", "colombia", "CO", "COL", "57", "Bogotá", "Americas", "South America", "48759958", "4,-72", "Colombian", "UTC-05:00", "Colombian peso", "COP", "$", "https://restcountries.eu/data/col.svg", "");
INSERT INTO `manl_countries` VALUES("53", "Comoros", "comoros", "KM", "COM", "269", "Moroni", "Africa", "Eastern Africa", "806153", "-12.16666666,44.25", "Comoran", "UTC+03:00", "Comorian franc", "KMF", "Fr", "https://restcountries.eu/data/com.svg", "");
INSERT INTO `manl_countries` VALUES("54", "Congo", "congo", "CG", "COG", "242", "Brazzaville", "Africa", "Middle Africa", "4741000", "-1,15", "Congolese", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/cog.svg", "");
INSERT INTO `manl_countries` VALUES("55", "Democratic Republic of the Congo", "democratic-republic-of-the-congo", "CD", "COD", "243", "Kinshasa", "Africa", "Middle Africa", "85026000", "0,25", "Congolese", "UTC+01:00,UTC+02:00", "Congolese franc", "CDF", "Fr", "https://restcountries.eu/data/cod.svg", "");
INSERT INTO `manl_countries` VALUES("56", "Cook Islands", "cook-islands", "CK", "COK", "682", "Avarua", "Oceania", "Polynesia", "18100", "-21.23333333,-159.76666666", "Cook Islander", "UTC-10:00", "New Zealand dollar", "NZD", "$", "https://restcountries.eu/data/cok.svg", "");
INSERT INTO `manl_countries` VALUES("57", "Costa Rica", "costa-rica", "CR", "CRI", "506", "San José", "Americas", "Central America", "4890379", "10,-84", "Costa Rican", "UTC-06:00", "Costa Rican colón", "CRC", "₡", "https://restcountries.eu/data/cri.svg", "");
INSERT INTO `manl_countries` VALUES("58", "Croatia", "croatia", "HR", "HRV", "385", "Zagreb", "Europe", "Southern Europe", "4190669", "45.16666666,15.5", "Croatian", "UTC+01:00", "Croatian kuna", "HRK", "kn", "https://restcountries.eu/data/hrv.svg", "");
INSERT INTO `manl_countries` VALUES("59", "Cuba", "cuba", "CU", "CUB", "53", "Havana", "Americas", "Caribbean", "11239004", "21.5,-80", "Cuban", "UTC-05:00", "Cuban convertible peso", "CUC", "$", "https://restcountries.eu/data/cub.svg", "");
INSERT INTO `manl_countries` VALUES("60", "Curaçao", "curacao", "CW", "CUW", "599", "Willemstad", "Americas", "Caribbean", "154843", "12.116667,-68.933333", "Dutch", "UTC-04:00", "Netherlands Antillean guilder", "ANG", "ƒ", "https://restcountries.eu/data/cuw.svg", "");
INSERT INTO `manl_countries` VALUES("61", "Cyprus", "cyprus", "CY", "CYP", "357", "Nicosia", "Europe", "Southern Europe", "847000", "35,33", "Cypriot", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/cyp.svg", "");
INSERT INTO `manl_countries` VALUES("62", "Czechia", "czechia", "CZ", "CZE", "420", "Prague", "Europe", "Eastern Europe", "10558524", "49.75,15.5", "Czech", "UTC+01:00", "Czech koruna", "CZK", "Kč", "https://restcountries.eu/data/cze.svg", "");
INSERT INTO `manl_countries` VALUES("63", "Denmark", "denmark", "DK", "DNK", "45", "Copenhagen", "Europe", "Northern Europe", "5717014", "56,10", "Danish", "UTC-04:00,UTC-03:00,UTC-01:00,UTC,UTC+01:00", "Danish krone", "DKK", "kr", "https://restcountries.eu/data/dnk.svg", "");
INSERT INTO `manl_countries` VALUES("64", "Djibouti", "djibouti", "DJ", "DJI", "253", "Djibouti", "Africa", "Eastern Africa", "900000", "11.5,43", "Djibouti", "UTC+03:00", "Djiboutian franc", "DJF", "Fr", "https://restcountries.eu/data/dji.svg", "");
INSERT INTO `manl_countries` VALUES("65", "Dominica", "dominica", "DM", "DMA", "1767", "Roseau", "Americas", "Caribbean", "71293", "15.41666666,-61.33333333", "Dominican", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/dma.svg", "");
INSERT INTO `manl_countries` VALUES("66", "Dominican Republic", "dominican-republic", "DO", "DOM", "1809,1829,1849", "Santo Domingo", "Americas", "Caribbean", "10075045", "19,-70.66666666", "Dominican", "UTC-04:00", "Dominican peso", "DOP", "$", "https://restcountries.eu/data/dom.svg", "");
INSERT INTO `manl_countries` VALUES("67", "Ecuador", "ecuador", "EC", "ECU", "593", "Quito", "Americas", "South America", "16545799", "-2,-77.5", "Ecuadorean", "UTC-06:00,UTC-05:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/ecu.svg", "");
INSERT INTO `manl_countries` VALUES("68", "Egypt", "egypt", "EG", "EGY", "20", "Cairo", "Africa", "Northern Africa", "91290000", "27,30", "Egyptian", "UTC+02:00", "Egyptian pound", "EGP", "£", "https://restcountries.eu/data/egy.svg", "");
INSERT INTO `manl_countries` VALUES("69", "El Salvador", "el-salvador", "SV", "SLV", "503", "San Salvador", "Americas", "Central America", "6520675", "13.83333333,-88.91666666", "Salvadoran", "UTC-06:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/slv.svg", "");
INSERT INTO `manl_countries` VALUES("70", "Equatorial Guinea", "equatorial-guinea", "GQ", "GNQ", "240", "Malabo", "Africa", "Middle Africa", "1222442", "2,10", "Equatorial Guinean", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/gnq.svg", "");
INSERT INTO `manl_countries` VALUES("71", "Eritrea", "eritrea", "ER", "ERI", "291", "Asmara", "Africa", "Eastern Africa", "5352000", "15,39", "Eritrean", "UTC+03:00", "Eritrean nakfa", "ERN", "Nfk", "https://restcountries.eu/data/eri.svg", "");
INSERT INTO `manl_countries` VALUES("72", "Estonia", "estonia", "EE", "EST", "372", "Tallinn", "Europe", "Northern Europe", "1315944", "59,26", "Estonian", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/est.svg", "");
INSERT INTO `manl_countries` VALUES("73", "Ethiopia", "ethiopia", "ET", "ETH", "251", "Addis Ababa", "Africa", "Eastern Africa", "92206005", "8,38", "Ethiopian", "UTC+03:00", "Ethiopian birr", "ETB", "Br", "https://restcountries.eu/data/eth.svg", "");
INSERT INTO `manl_countries` VALUES("74", "Falkland Islands", "falkland-islands", "FK", "FLK", "500", "Stanley", "Americas", "South America", "2563", "-51.75,-59", "Falkland Islander", "UTC-04:00", "Falkland Islands pound", "FKP", "£", "https://restcountries.eu/data/flk.svg", "");
INSERT INTO `manl_countries` VALUES("75", "Faroe Islands", "faroe-islands", "FO", "FRO", "298", "Tórshavn", "Europe", "Northern Europe", "49376", "62,-7", "Faroese", "UTC+00:00", "Danish krone", "DKK", "kr", "https://restcountries.eu/data/fro.svg", "");
INSERT INTO `manl_countries` VALUES("76", "Fiji", "fiji", "FJ", "FJI", "679", "Suva", "Oceania", "Melanesia", "867000", "-18,175", "Fijian", "UTC+12:00", "Fijian dollar", "FJD", "$", "https://restcountries.eu/data/fji.svg", "");
INSERT INTO `manl_countries` VALUES("77", "Finland", "finland", "FI", "FIN", "358", "Helsinki", "Europe", "Northern Europe", "5491817", "64,26", "Finnish", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/fin.svg", "");
INSERT INTO `manl_countries` VALUES("78", "France", "france", "FR", "FRA", "33", "Paris", "Europe", "Western Europe", "66710000", "46,2", "French", "UTC-10:00,UTC-09:30,UTC-09:00,UTC-08:00,UTC-04:00,UTC-03:00,UTC+01:00,UTC+03:00,UTC+04:00,UTC+05:00,UTC+11:00,UTC+12:00", "Euro", "EUR", "€", "https://restcountries.eu/data/fra.svg", "");
INSERT INTO `manl_countries` VALUES("79", "French Guiana", "french-guiana", "GF", "GUF", "594", "Cayenne", "Americas", "South America", "254541", "4,-53", "", "UTC-03:00", "Euro", "EUR", "€", "https://restcountries.eu/data/guf.svg", "");
INSERT INTO `manl_countries` VALUES("80", "French Polynesia", "french-polynesia", "PF", "PYF", "689", "Papeetē", "Oceania", "Polynesia", "271800", "-15,-140", "French Polynesian", "UTC-10:00,UTC-09:30,UTC-09:00", "CFP franc", "XPF", "Fr", "https://restcountries.eu/data/pyf.svg", "");
INSERT INTO `manl_countries` VALUES("81", "French Southern Territories", "french-southern-territories", "TF", "ATF", "", "Port-aux-Français", "Africa", "Southern Africa", "140", "-49.25,69.167", "French", "UTC+05:00", "Euro", "EUR", "€", "https://restcountries.eu/data/atf.svg", "");
INSERT INTO `manl_countries` VALUES("82", "Gabon", "gabon", "GA", "GAB", "241", "Libreville", "Africa", "Middle Africa", "1802278", "-1,11.75", "Gabonese", "UTC+01:00", "Central African CFA franc", "XAF", "Fr", "https://restcountries.eu/data/gab.svg", "");
INSERT INTO `manl_countries` VALUES("83", "Gambia", "gambia", "GM", "GMB", "220", "Banjul", "Africa", "Western Africa", "1882450", "13.46666666,-16.56666666", "Gambian", "UTC+00:00", "Gambian dalasi", "GMD", "D", "https://restcountries.eu/data/gmb.svg", "");
INSERT INTO `manl_countries` VALUES("84", "Georgia", "georgia", "GE", "GEO", "995", "Tbilisi", "Asia", "Western Asia", "3720400", "42,43.5", "Georgian", "UTC-05:00", "Georgian Lari", "GEL", "ლ", "https://restcountries.eu/data/geo.svg", "");
INSERT INTO `manl_countries` VALUES("85", "Germany", "germany", "DE", "DEU", "49", "Berlin", "Europe", "Western Europe", "81770900", "51,9", "German", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/deu.svg", "");
INSERT INTO `manl_countries` VALUES("86", "Ghana", "ghana", "GH", "GHA", "233", "Accra", "Africa", "Western Africa", "27670174", "8,-2", "Ghanaian", "UTC", "Ghanaian cedi", "GHS", "₵", "https://restcountries.eu/data/gha.svg", "");
INSERT INTO `manl_countries` VALUES("87", "Gibraltar", "gibraltar", "GI", "GIB", "350", "Gibraltar", "Europe", "Southern Europe", "33140", "36.13333333,-5.35", "Gibraltar", "UTC+01:00", "Gibraltar pound", "GIP", "£", "https://restcountries.eu/data/gib.svg", "");
INSERT INTO `manl_countries` VALUES("88", "Greece", "greece", "GR", "GRC", "30", "Athens", "Europe", "Southern Europe", "10858018", "39,22", "Greek", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/grc.svg", "");
INSERT INTO `manl_countries` VALUES("89", "Greenland", "greenland", "GL", "GRL", "299", "Nuuk", "Americas", "Northern America", "55847", "72,-40", "Greenlandic", "UTC-04:00,UTC-03:00,UTC-01:00,UTC+00:00", "Danish krone", "DKK", "kr", "https://restcountries.eu/data/grl.svg", "");
INSERT INTO `manl_countries` VALUES("90", "Grenada", "grenada", "GD", "GRD", "1473", "St. George\'s", "Americas", "Caribbean", "103328", "12.11666666,-61.66666666", "Grenadian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/grd.svg", "");
INSERT INTO `manl_countries` VALUES("91", "Guadeloupe", "guadeloupe", "GP", "GLP", "590", "Basse-Terre", "Americas", "Caribbean", "400132", "16.25,-61.583333", "Guadeloupian", "UTC-04:00", "Euro", "EUR", "€", "https://restcountries.eu/data/glp.svg", "");
INSERT INTO `manl_countries` VALUES("92", "Guam", "guam", "GU", "GUM", "1671", "Hagåtña", "Oceania", "Micronesia", "184200", "13.46666666,144.78333333", "Guamanian", "UTC+10:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/gum.svg", "");
INSERT INTO `manl_countries` VALUES("93", "Guatemala", "guatemala", "GT", "GTM", "502", "Guatemala City", "Americas", "Central America", "16176133", "15.5,-90.25", "Guatemalan", "UTC-06:00", "Guatemalan quetzal", "GTQ", "Q", "https://restcountries.eu/data/gtm.svg", "");
INSERT INTO `manl_countries` VALUES("94", "Guernsey", "guernsey", "GG", "GGY", "44", "St. Peter Port", "Europe", "Northern Europe", "62999", "49.46666666,-2.58333333", "Channel Islander", "UTC+00:00", "British pound", "GBP", "£", "https://restcountries.eu/data/ggy.svg", "");
INSERT INTO `manl_countries` VALUES("95", "Guinea", "guinea", "GN", "GIN", "224", "Conakry", "Africa", "Western Africa", "12947000", "11,-10", "Guinean", "UTC", "Guinean franc", "GNF", "Fr", "https://restcountries.eu/data/gin.svg", "");
INSERT INTO `manl_countries` VALUES("96", "Guinea-Bissau", "guinea-bissau", "GW", "GNB", "245", "Bissau", "Africa", "Western Africa", "1547777", "12,-15", "Guinea-Bissauan", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/gnb.svg", "");
INSERT INTO `manl_countries` VALUES("97", "Guyana", "guyana", "GY", "GUY", "592", "Georgetown", "Americas", "South America", "746900", "5,-59", "Guyanese", "UTC-04:00", "Guyanese dollar", "GYD", "$", "https://restcountries.eu/data/guy.svg", "");
INSERT INTO `manl_countries` VALUES("98", "Haiti", "haiti", "HT", "HTI", "509", "Port-au-Prince", "Americas", "Caribbean", "11078033", "19,-72.41666666", "Haitian", "UTC-05:00", "Haitian gourde", "HTG", "G", "https://restcountries.eu/data/hti.svg", "");
INSERT INTO `manl_countries` VALUES("99", "Heard Island and McDonald Islands", "heard-island-and-mcdonald-islands", "HM", "HMD", "", "", "", "", "0", "-53.1,72.51666666", "Heard and McDonald Islander", "UTC+05:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/hmd.svg", "");
INSERT INTO `manl_countries` VALUES("100", "Holy See", "holy-see", "VA", "VAT", "379", "Rome", "Europe", "Southern Europe", "451", "41.9,12.45", "", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/vat.svg", "");
INSERT INTO `manl_countries` VALUES("101", "Honduras", "honduras", "HN", "HND", "504", "Tegucigalpa", "Americas", "Central America", "8576532", "15,-86.5", "Honduran", "UTC-06:00", "Honduran lempira", "HNL", "L", "https://restcountries.eu/data/hnd.svg", "");
INSERT INTO `manl_countries` VALUES("102", "Hong Kong", "hong-kong", "HK", "HKG", "852", "City of Victoria", "Asia", "Eastern Asia", "7324300", "22.25,114.16666666", "Chinese", "UTC+08:00", "Hong Kong dollar", "HKD", "$", "https://restcountries.eu/data/hkg.svg", "");
INSERT INTO `manl_countries` VALUES("103", "Hungary", "hungary", "HU", "HUN", "36", "Budapest", "Europe", "Eastern Europe", "9823000", "47,20", "Hungarian", "UTC+01:00", "Hungarian forint", "HUF", "Ft", "https://restcountries.eu/data/hun.svg", "");
INSERT INTO `manl_countries` VALUES("104", "Iceland", "iceland", "IS", "ISL", "354", "Reykjavík", "Europe", "Northern Europe", "334300", "65,-18", "Icelander", "UTC", "Icelandic króna", "ISK", "kr", "https://restcountries.eu/data/isl.svg", "");
INSERT INTO `manl_countries` VALUES("105", "India", "india", "IN", "IND", "91", "New Delhi", "Asia", "Southern Asia", "1295210000", "20,77", "Indian", "UTC+05:30", "Indian rupee", "INR", "₹", "https://restcountries.eu/data/ind.svg", "");
INSERT INTO `manl_countries` VALUES("106", "Indonesia", "indonesia", "ID", "IDN", "62", "Jakarta", "Asia", "South-Eastern Asia", "258705000", "-5,120", "Indonesian", "UTC+07:00,UTC+08:00,UTC+09:00", "Indonesian rupiah", "IDR", "Rp", "https://restcountries.eu/data/idn.svg", "");
INSERT INTO `manl_countries` VALUES("107", "Côte d\'Ivoire", "cote-divoire", "CI", "CIV", "225", "Yamoussoukro", "Africa", "Western Africa", "22671331", "8,-5", "Ivorian", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/civ.svg", "");
INSERT INTO `manl_countries` VALUES("108", "Iran", "iran-islamic-republic-of", "IR", "IRN", "98", "Tehran", "Asia", "Southern Asia", "79369900", "32,53", "Iranian", "UTC+03:30", "Iranian rial", "IRR", "﷼", "https://restcountries.eu/data/irn.svg", "");
INSERT INTO `manl_countries` VALUES("109", "Iraq", "iraq", "IQ", "IRQ", "964", "Baghdad", "Asia", "Western Asia", "37883543", "33,44", "Iraqi", "UTC+03:00", "Iraqi dinar", "IQD", "ع.د", "https://restcountries.eu/data/irq.svg", "");
INSERT INTO `manl_countries` VALUES("110", "Ireland", "ireland", "IE", "IRL", "353", "Dublin", "Europe", "Northern Europe", "6378000", "53,-8", "Irish", "UTC", "Euro", "EUR", "€", "https://restcountries.eu/data/irl.svg", "");
INSERT INTO `manl_countries` VALUES("111", "Isle of Man", "isle-of-man", "IM", "IMN", "44", "Douglas", "Europe", "Northern Europe", "84497", "54.25,-4.5", "Manx", "UTC+00:00", "British pound", "GBP", "£", "https://restcountries.eu/data/imn.svg", "");
INSERT INTO `manl_countries` VALUES("112", "Israel", "israel", "IL", "ISR", "972", "Jerusalem", "Asia", "Western Asia", "8527400", "31.5,34.75", "Israeli", "UTC+02:00", "Israeli new shekel", "ILS", "₪", "https://restcountries.eu/data/isr.svg", "");
INSERT INTO `manl_countries` VALUES("113", "Italy", "italy", "IT", "ITA", "39", "Rome", "Europe", "Southern Europe", "60665551", "42.83333333,12.83333333", "Italian", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/ita.svg", "");
INSERT INTO `manl_countries` VALUES("114", "Jamaica", "jamaica", "JM", "JAM", "1876", "Kingston", "Americas", "Caribbean", "2723246", "18.25,-77.5", "Jamaican", "UTC-05:00", "Jamaican dollar", "JMD", "$", "https://restcountries.eu/data/jam.svg", "");
INSERT INTO `manl_countries` VALUES("115", "Japan", "japan", "JP", "JPN", "81", "Tokyo", "Asia", "Eastern Asia", "126960000", "36,138", "Japanese", "UTC+09:00", "Japanese yen", "JPY", "¥", "https://restcountries.eu/data/jpn.svg", "");
INSERT INTO `manl_countries` VALUES("116", "Jersey", "jersey", "JE", "JEY", "44", "Saint Helier", "Europe", "Northern Europe", "100800", "49.25,-2.16666666", "Channel Islander", "UTC+01:00", "British pound", "GBP", "£", "https://restcountries.eu/data/jey.svg", "");
INSERT INTO `manl_countries` VALUES("117", "Jordan", "jordan", "JO", "JOR", "962", "Amman", "Asia", "Western Asia", "9531712", "31,36", "Jordanian", "UTC+03:00", "Jordanian dinar", "JOD", "د.ا", "https://restcountries.eu/data/jor.svg", "");
INSERT INTO `manl_countries` VALUES("118", "Kazakhstan", "kazakhstan", "KZ", "KAZ", "76,77", "Astana", "Asia", "Central Asia", "17753200", "48,68", "Kazakhstani", "UTC+05:00,UTC+06:00", "Kazakhstani tenge", "KZT", "", "https://restcountries.eu/data/kaz.svg", "");
INSERT INTO `manl_countries` VALUES("119", "Kenya", "kenya", "KE", "KEN", "254", "Nairobi", "Africa", "Eastern Africa", "47251000", "1,38", "Kenyan", "UTC+03:00", "Kenyan shilling", "KES", "Sh", "https://restcountries.eu/data/ken.svg", "");
INSERT INTO `manl_countries` VALUES("120", "Kiribati", "kiribati", "KI", "KIR", "686", "South Tarawa", "Oceania", "Micronesia", "113400", "1.41666666,173", "I-Kiribati", "UTC+12:00,UTC+13:00,UTC+14:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/kir.svg", "");
INSERT INTO `manl_countries` VALUES("121", "Kuwait", "kuwait", "KW", "KWT", "965", "Kuwait City", "Asia", "Western Asia", "4183658", "29.5,45.75", "Kuwaiti", "UTC+03:00", "Kuwaiti dinar", "KWD", "د.ك", "https://restcountries.eu/data/kwt.svg", "");
INSERT INTO `manl_countries` VALUES("122", "Kyrgyzstan", "kyrgyzstan", "KG", "KGZ", "996", "Bishkek", "Asia", "Central Asia", "6047800", "41,75", "Kirghiz", "UTC+06:00", "Kyrgyzstani som", "KGS", "с", "https://restcountries.eu/data/kgz.svg", "");
INSERT INTO `manl_countries` VALUES("123", "Lao People\'s Democratic Republic", "lao-peoples-democratic-republic", "LA", "LAO", "856", "Vientiane", "Asia", "South-Eastern Asia", "6492400", "18,105", "Laotian", "UTC+07:00", "Lao kip", "LAK", "₭", "https://restcountries.eu/data/lao.svg", "");
INSERT INTO `manl_countries` VALUES("124", "Latvia", "latvia", "LV", "LVA", "371", "Riga", "Europe", "Northern Europe", "1961600", "57,25", "Latvian", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/lva.svg", "");
INSERT INTO `manl_countries` VALUES("125", "Lebanon", "lebanon", "LB", "LBN", "961", "Beirut", "Asia", "Western Asia", "5988000", "33.83333333,35.83333333", "Lebanese", "UTC+02:00", "Lebanese pound", "LBP", "ل.ل", "https://restcountries.eu/data/lbn.svg", "");
INSERT INTO `manl_countries` VALUES("126", "Lesotho", "lesotho", "LS", "LSO", "266", "Maseru", "Africa", "Southern Africa", "1894194", "-29.5,28.5", "Mosotho", "UTC+02:00", "Lesotho loti", "LSL", "L", "https://restcountries.eu/data/lso.svg", "");
INSERT INTO `manl_countries` VALUES("127", "Liberia", "liberia", "LR", "LBR", "231", "Monrovia", "Africa", "Western Africa", "4615000", "6.5,-9.5", "Liberian", "UTC", "Liberian dollar", "LRD", "$", "https://restcountries.eu/data/lbr.svg", "");
INSERT INTO `manl_countries` VALUES("128", "Libya", "libya", "LY", "LBY", "218", "Tripoli", "Africa", "Northern Africa", "6385000", "25,17", "Libyan", "UTC+01:00", "Libyan dinar", "LYD", "ل.د", "https://restcountries.eu/data/lby.svg", "");
INSERT INTO `manl_countries` VALUES("129", "Liechtenstein", "liechtenstein", "LI", "LIE", "423", "Vaduz", "Europe", "Western Europe", "37623", "47.26666666,9.53333333", "Liechtensteiner", "UTC+01:00", "Swiss franc", "CHF", "Fr", "https://restcountries.eu/data/lie.svg", "");
INSERT INTO `manl_countries` VALUES("130", "Lithuania", "lithuania", "LT", "LTU", "370", "Vilnius", "Europe", "Northern Europe", "2872294", "56,24", "Lithuanian", "UTC+02:00", "Euro", "EUR", "€", "https://restcountries.eu/data/ltu.svg", "");
INSERT INTO `manl_countries` VALUES("131", "Luxembourg", "luxembourg", "LU", "LUX", "352", "Luxembourg", "Europe", "Western Europe", "576200", "49.75,6.16666666", "Luxembourger", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/lux.svg", "");
INSERT INTO `manl_countries` VALUES("132", "Macao", "macao", "MO", "MAC", "853", "", "Asia", "Eastern Asia", "649100", "22.16666666,113.55", "Chinese", "UTC+08:00", "Macanese pataca", "MOP", "P", "https://restcountries.eu/data/mac.svg", "");
INSERT INTO `manl_countries` VALUES("133", "Macedonia (the former Yugoslav Republic of)", "macedonia-the-former-yugoslav-republic-of", "MK", "MKD", "389", "Skopje", "Europe", "Southern Europe", "2058539", "41.83333333,22", "Macedonian", "UTC+01:00", "Macedonian denar", "MKD", "ден", "https://restcountries.eu/data/mkd.svg", "");
INSERT INTO `manl_countries` VALUES("134", "Madagascar", "madagascar", "MG", "MDG", "261", "Antananarivo", "Africa", "Eastern Africa", "22434363", "-20,47", "Malagasy", "UTC+03:00", "Malagasy ariary", "MGA", "Ar", "https://restcountries.eu/data/mdg.svg", "");
INSERT INTO `manl_countries` VALUES("135", "Malawi", "malawi", "MW", "MWI", "265", "Lilongwe", "Africa", "Eastern Africa", "16832910", "-13.5,34", "Malawian", "UTC+02:00", "Malawian kwacha", "MWK", "MK", "https://restcountries.eu/data/mwi.svg", "");
INSERT INTO `manl_countries` VALUES("136", "Malaysia", "malaysia", "MY", "MYS", "60", "Kuala Lumpur", "Asia", "South-Eastern Asia", "31405416", "2.5,112.5", "Malaysian", "UTC+08:00", "Malaysian ringgit", "MYR", "RM", "https://restcountries.eu/data/mys.svg", "");
INSERT INTO `manl_countries` VALUES("137", "Maldives", "maldives", "MV", "MDV", "960", "Malé", "Asia", "Southern Asia", "344023", "3.25,73", "Maldivan", "UTC+05:00", "Maldivian rufiyaa", "MVR", ".ރ", "https://restcountries.eu/data/mdv.svg", "");
INSERT INTO `manl_countries` VALUES("138", "Mali", "mali", "ML", "MLI", "223", "Bamako", "Africa", "Western Africa", "18135000", "17,-4", "Malian", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/mli.svg", "");
INSERT INTO `manl_countries` VALUES("139", "Malta", "malta", "MT", "MLT", "356", "Valletta", "Europe", "Southern Europe", "425384", "35.83333333,14.58333333", "Maltese", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/mlt.svg", "");
INSERT INTO `manl_countries` VALUES("140", "Marshall Islands", "marshall-islands", "MH", "MHL", "692", "Majuro", "Oceania", "Micronesia", "54880", "9,168", "Marshallese", "UTC+12:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/mhl.svg", "");
INSERT INTO `manl_countries` VALUES("141", "Martinique", "martinique", "MQ", "MTQ", "596", "Fort-de-France", "Americas", "Caribbean", "378243", "14.666667,-61", "French", "UTC-04:00", "Euro", "EUR", "€", "https://restcountries.eu/data/mtq.svg", "");
INSERT INTO `manl_countries` VALUES("142", "Mauritania", "mauritania", "MR", "MRT", "222", "Nouakchott", "Africa", "Western Africa", "3718678", "20,-12", "Mauritanian", "UTC", "Mauritanian ouguiya", "MRO", "UM", "https://restcountries.eu/data/mrt.svg", "");
INSERT INTO `manl_countries` VALUES("143", "Mauritius", "mauritius", "MU", "MUS", "230", "Port Louis", "Africa", "Eastern Africa", "1262879", "-20.28333333,57.55", "Mauritian", "UTC+04:00", "Mauritian rupee", "MUR", "₨", "https://restcountries.eu/data/mus.svg", "");
INSERT INTO `manl_countries` VALUES("144", "Mayotte", "mayotte", "YT", "MYT", "262", "Mamoudzou", "Africa", "Eastern Africa", "226915", "-12.83333333,45.16666666", "French", "UTC+03:00", "Euro", "EUR", "€", "https://restcountries.eu/data/myt.svg", "");
INSERT INTO `manl_countries` VALUES("145", "Mexico", "mexico", "MX", "MEX", "52", "Mexico City", "Americas", "Central America", "122273473", "23,-102", "Mexican", "UTC-08:00,UTC-07:00,UTC-06:00", "Mexican peso", "MXN", "$", "https://restcountries.eu/data/mex.svg", "");
INSERT INTO `manl_countries` VALUES("146", "Micronesia", "micronesia", "FM", "FSM", "691", "Palikir", "Oceania", "Micronesia", "102800", "6.91666666,158.25", "Micronesian", "UTC+10:00,UTC+11", "[D]", "", "$", "https://restcountries.eu/data/fsm.svg", "");
INSERT INTO `manl_countries` VALUES("147", "Moldova", "moldova", "MD", "MDA", "373", "Chișinău", "Europe", "Eastern Europe", "3553100", "47,29", "Moldovan", "UTC+02:00", "Moldovan leu", "MDL", "L", "https://restcountries.eu/data/mda.svg", "");
INSERT INTO `manl_countries` VALUES("148", "Monaco", "monaco", "MC", "MCO", "377", "Monaco", "Europe", "Western Europe", "38400", "43.73333333,7.4", "Monegasque", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/mco.svg", "");
INSERT INTO `manl_countries` VALUES("149", "Mongolia", "mongolia", "MN", "MNG", "976", "Ulan Bator", "Asia", "Eastern Asia", "3093100", "46,105", "Mongolian", "UTC+07:00,UTC+08:00", "Mongolian tögrög", "MNT", "₮", "https://restcountries.eu/data/mng.svg", "");
INSERT INTO `manl_countries` VALUES("150", "Montenegro", "montenegro", "ME", "MNE", "382", "Podgorica", "Europe", "Southern Europe", "621810", "42.5,19.3", "Montenegrin", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/mne.svg", "");
INSERT INTO `manl_countries` VALUES("151", "Montserrat", "montserrat", "MS", "MSR", "1664", "Plymouth", "Americas", "Caribbean", "4922", "16.75,-62.2", "Montserratian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/msr.svg", "");
INSERT INTO `manl_countries` VALUES("152", "Morocco", "morocco", "MA", "MAR", "212", "Rabat", "Africa", "Northern Africa", "33337529", "32,-5", "Moroccan", "UTC", "Moroccan dirham", "MAD", "د.م", "https://restcountries.eu/data/mar.svg", "");
INSERT INTO `manl_countries` VALUES("153", "Mozambique", "mozambique", "MZ", "MOZ", "258", "Maputo", "Africa", "Eastern Africa", "26423700", "-18.25,35", "Mozambican", "UTC+02:00", "Mozambican metical", "MZN", "MT", "https://restcountries.eu/data/moz.svg", "");
INSERT INTO `manl_countries` VALUES("154", "Myanmar", "myanmar", "MM", "MMR", "95", "Naypyidaw", "Asia", "South-Eastern Asia", "51419420", "22,98", "Burmese", "UTC+06:30", "Burmese kyat", "MMK", "Ks", "https://restcountries.eu/data/mmr.svg", "");
INSERT INTO `manl_countries` VALUES("155", "Namibia", "namibia", "NA", "NAM", "264", "Windhoek", "Africa", "Southern Africa", "2324388", "-22,17", "Namibian", "UTC+01:00", "Namibian dollar", "NAD", "$", "https://restcountries.eu/data/nam.svg", "");
INSERT INTO `manl_countries` VALUES("156", "Nauru", "nauru", "NR", "NRU", "674", "Yaren", "Oceania", "Micronesia", "10084", "-0.53333333,166.91666666", "Nauruan", "UTC+12:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/nru.svg", "");
INSERT INTO `manl_countries` VALUES("157", "Nepal", "nepal", "NP", "NPL", "977", "Kathmandu", "Asia", "Southern Asia", "28431500", "28,84", "Nepalese", "UTC+05:45", "Nepalese rupee", "NPR", "₨", "https://restcountries.eu/data/npl.svg", "");
INSERT INTO `manl_countries` VALUES("158", "Netherlands", "netherlands", "NL", "NLD", "31", "Amsterdam", "Europe", "Western Europe", "17019800", "52.5,5.75", "Dutch", "UTC-04:00,UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/nld.svg", "");
INSERT INTO `manl_countries` VALUES("159", "New Caledonia", "new-caledonia", "NC", "NCL", "687", "Nouméa", "Oceania", "Melanesia", "268767", "-21.5,165.5", "New Caledonian", "UTC+11:00", "CFP franc", "XPF", "Fr", "https://restcountries.eu/data/ncl.svg", "");
INSERT INTO `manl_countries` VALUES("160", "New Zealand", "new-zealand", "NZ", "NZL", "64", "Wellington", "Oceania", "Australia and New Zealand", "4697854", "-41,174", "New Zealander", "UTC-11:00,UTC-10:00,UTC+12:00,UTC+12:45,UTC+13:00", "New Zealand dollar", "NZD", "$", "https://restcountries.eu/data/nzl.svg", "");
INSERT INTO `manl_countries` VALUES("161", "Nicaragua", "nicaragua", "NI", "NIC", "505", "Managua", "Americas", "Central America", "6262703", "13,-85", "Nicaraguan", "UTC-06:00", "Nicaraguan córdoba", "NIO", "C$", "https://restcountries.eu/data/nic.svg", "");
INSERT INTO `manl_countries` VALUES("162", "Niger", "niger", "NE", "NER", "227", "Niamey", "Africa", "Western Africa", "20715000", "16,8", "Nigerien", "UTC+01:00", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/ner.svg", "");
INSERT INTO `manl_countries` VALUES("163", "Nigeria", "nigeria", "NG", "NGA", "234", "Abuja", "Africa", "Western Africa", "186988000", "10,8", "Nigerian", "UTC+01:00", "Nigerian naira", "NGN", "₦", "https://restcountries.eu/data/nga.svg", "");
INSERT INTO `manl_countries` VALUES("164", "Niue", "niue", "NU", "NIU", "683", "Alofi", "Oceania", "Polynesia", "1470", "-19.03333333,-169.86666666", "Niuean", "UTC-11:00", "New Zealand dollar", "NZD", "$", "https://restcountries.eu/data/niu.svg", "");
INSERT INTO `manl_countries` VALUES("165", "Norfolk Island", "norfolk-island", "NF", "NFK", "672", "Kingston", "Oceania", "Australia and New Zealand", "2302", "-29.03333333,167.95", "Norfolk Islander", "UTC+11:30", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/nfk.svg", "");
INSERT INTO `manl_countries` VALUES("166", "North Korea", "north-korea", "KP", "PRK", "850", "Pyongyang", "Asia", "Eastern Asia", "25281000", "40,127", "North Korean", "UTC+09:00", "North Korean won", "KPW", "₩", "https://restcountries.eu/data/prk.svg", "");
INSERT INTO `manl_countries` VALUES("167", "Northern Mariana Islands", "northern-mariana-islands", "MP", "MNP", "1670", "Saipan", "Oceania", "Micronesia", "56940", "15.2,145.75", "American", "UTC+10:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/mnp.svg", "");
INSERT INTO `manl_countries` VALUES("168", "Norway", "norway", "NO", "NOR", "47", "Oslo", "Europe", "Northern Europe", "5223256", "62,10", "Norwegian", "UTC+01:00", "Norwegian krone", "NOK", "kr", "https://restcountries.eu/data/nor.svg", "");
INSERT INTO `manl_countries` VALUES("169", "Oman", "oman", "OM", "OMN", "968", "Muscat", "Asia", "Western Asia", "4420133", "21,57", "Omani", "UTC+04:00", "Omani rial", "OMR", "ر.ع", "https://restcountries.eu/data/omn.svg", "");
INSERT INTO `manl_countries` VALUES("170", "Pakistan", "pakistan", "PK", "PAK", "92", "Islamabad", "Asia", "Southern Asia", "194125062", "30,70", "Pakistani", "UTC+05:00", "Pakistani rupee", "PKR", "₨", "https://restcountries.eu/data/pak.svg", "");
INSERT INTO `manl_countries` VALUES("171", "Palau", "palau", "PW", "PLW", "680", "Ngerulmud", "Oceania", "Micronesia", "17950", "7.5,134.5", "Palauan", "UTC+09:00", "[E]", "(no", "$", "https://restcountries.eu/data/plw.svg", "");
INSERT INTO `manl_countries` VALUES("172", "Palestine", "palestine", "PS", "PSE", "970", "Ramallah", "Asia", "Western Asia", "4682467", "31.9,35.2", "Palestinian", "UTC+02:00", "Israeli new sheqel", "ILS", "₪", "https://restcountries.eu/data/pse.svg", "");
INSERT INTO `manl_countries` VALUES("173", "Panama", "panama", "PA", "PAN", "507", "Panama City", "Americas", "Central America", "3814672", "9,-80", "Panamanian", "UTC-05:00", "Panamanian balboa", "PAB", "B/.", "https://restcountries.eu/data/pan.svg", "");
INSERT INTO `manl_countries` VALUES("174", "Papua New Guinea", "papua-new-guinea", "PG", "PNG", "675", "Port Moresby", "Oceania", "Melanesia", "8083700", "-6,147", "Papua New Guinean", "UTC+10:00", "Papua New Guinean kina", "PGK", "K", "https://restcountries.eu/data/png.svg", "");
INSERT INTO `manl_countries` VALUES("175", "Paraguay", "paraguay", "PY", "PRY", "595", "Asunción", "Americas", "South America", "6854536", "-23,-58", "Paraguayan", "UTC-04:00", "Paraguayan guaraní", "PYG", "₲", "https://restcountries.eu/data/pry.svg", "");
INSERT INTO `manl_countries` VALUES("176", "Peru", "peru", "PE", "PER", "51", "Lima", "Americas", "South America", "31488700", "-10,-76", "Peruvian", "UTC-05:00", "Peruvian sol", "PEN", "S/.", "https://restcountries.eu/data/per.svg", "");
INSERT INTO `manl_countries` VALUES("177", "Philippines", "philippines", "PH", "PHL", "63", "Manila", "Asia", "South-Eastern Asia", "103279800", "13,122", "Filipino", "UTC+08:00", "Philippine peso", "PHP", "₱", "https://restcountries.eu/data/phl.svg", "");
INSERT INTO `manl_countries` VALUES("178", "Pitcairn", "pitcairn", "PN", "PCN", "64", "Adamstown", "Oceania", "Polynesia", "56", "-25.06666666,-130.1", "Pitcairn Islander", "UTC-08:00", "New Zealand dollar", "NZD", "$", "https://restcountries.eu/data/pcn.svg", "");
INSERT INTO `manl_countries` VALUES("179", "Poland", "poland", "PL", "POL", "48", "Warsaw", "Europe", "Eastern Europe", "38437239", "52,20", "Polish", "UTC+01:00", "Polish złoty", "PLN", "zł", "https://restcountries.eu/data/pol.svg", "");
INSERT INTO `manl_countries` VALUES("180", "Portugal", "portugal", "PT", "PRT", "351", "Lisbon", "Europe", "Southern Europe", "10374822", "39.5,-8", "Portuguese", "UTC-01:00,UTC", "Euro", "EUR", "€", "https://restcountries.eu/data/prt.svg", "");
INSERT INTO `manl_countries` VALUES("181", "Puerto Rico", "puerto-rico", "PR", "PRI", "1787,1939", "San Juan", "Americas", "Caribbean", "3474182", "18.25,-66.5", "Puerto Rican", "UTC-04:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/pri.svg", "");
INSERT INTO `manl_countries` VALUES("182", "Qatar", "qatar", "QA", "QAT", "974", "Doha", "Asia", "Western Asia", "2587564", "25.5,51.25", "Qatari", "UTC+03:00", "Qatari riyal", "QAR", "ر.ق", "https://restcountries.eu/data/qat.svg", "");
INSERT INTO `manl_countries` VALUES("183", "Kosovo", "kosovo", "XK", "KOS", "383", "Pristina", "Europe", "Eastern Europe", "1733842", "42.666667,21.166667", "Kosovar", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/kos.svg", "");
INSERT INTO `manl_countries` VALUES("184", "Réunion", "reunion", "RE", "REU", "262", "Saint-Denis", "Africa", "Eastern Africa", "840974", "-21.15,55.5", "French", "UTC+04:00", "Euro", "EUR", "€", "https://restcountries.eu/data/reu.svg", "");
INSERT INTO `manl_countries` VALUES("185", "Romania", "romania", "RO", "ROU", "40", "Bucharest", "Europe", "Eastern Europe", "19861408", "46,25", "Romanian", "UTC+02:00", "Romanian leu", "RON", "lei", "https://restcountries.eu/data/rou.svg", "");
INSERT INTO `manl_countries` VALUES("186", "Russia", "russia", "RU", "RUS", "7", "Moscow", "Europe", "Eastern Europe", "146599183", "60,100", "Russian", "UTC+03:00,UTC+04:00,UTC+06:00,UTC+07:00,UTC+08:00,UTC+09:00,UTC+10:00,UTC+11:00,UTC+12:00", "Russian ruble", "RUB", "₽", "https://restcountries.eu/data/rus.svg", "");
INSERT INTO `manl_countries` VALUES("187", "Rwanda", "rwanda", "RW", "RWA", "250", "Kigali", "Africa", "Eastern Africa", "11553188", "-2,30", "Rwandan", "UTC+02:00", "Rwandan franc", "RWF", "Fr", "https://restcountries.eu/data/rwa.svg", "");
INSERT INTO `manl_countries` VALUES("188", "Saint Barthélemy", "saint-barthelemy", "BL", "BLM", "590", "Gustavia", "Americas", "Caribbean", "9417", "18.5,-63.41666666", "Saint Barthélemy Islander", "UTC-04:00", "Euro", "EUR", "€", "https://restcountries.eu/data/blm.svg", "");
INSERT INTO `manl_countries` VALUES("189", "Saint Helena, Ascension and Tristan da Cunha", "saint-helena-ascension-and-tristan-da-cunha", "SH", "SHN", "290", "Jamestown", "Africa", "Western Africa", "4255", "-15.95,-5.7", "Saint Helenian", "UTC+00:00", "Saint Helena pound", "SHP", "£", "https://restcountries.eu/data/shn.svg", "");
INSERT INTO `manl_countries` VALUES("190", "Saint Kitts and Nevis", "saint-kitts-and-nevis", "KN", "KNA", "1869", "Basseterre", "Americas", "Caribbean", "46204", "17.33333333,-62.75", "Kittian and Nevisian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/kna.svg", "");
INSERT INTO `manl_countries` VALUES("191", "Saint Lucia", "saint-lucia", "LC", "LCA", "1758", "Castries", "Americas", "Caribbean", "186000", "13.88333333,-60.96666666", "Saint Lucian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/lca.svg", "");
INSERT INTO `manl_countries` VALUES("192", "Saint Martin", "saint-martin", "MF", "MAF", "590", "Marigot", "Americas", "Caribbean", "36979", "18.08333333,-63.95", "Saint Martin Islander", "UTC-04:00", "Euro", "EUR", "€", "https://restcountries.eu/data/maf.svg", "");
INSERT INTO `manl_countries` VALUES("193", "Saint Pierre and Miquelon", "saint-pierre-and-miquelon", "PM", "SPM", "508", "Saint-Pierre", "Americas", "Northern America", "6069", "46.83333333,-56.33333333", "French", "UTC-03:00", "Euro", "EUR", "€", "https://restcountries.eu/data/spm.svg", "");
INSERT INTO `manl_countries` VALUES("194", "Saint Vincent and the Grenadines", "saint-vincent-and-the-grenadines", "VC", "VCT", "1784", "Kingstown", "Americas", "Caribbean", "109991", "13.25,-61.2", "Saint Vincentian", "UTC-04:00", "East Caribbean dollar", "XCD", "$", "https://restcountries.eu/data/vct.svg", "");
INSERT INTO `manl_countries` VALUES("195", "Samoa", "samoa", "WS", "WSM", "685", "Apia", "Oceania", "Polynesia", "194899", "-13.58333333,-172.33333333", "Samoan", "UTC+13:00", "Samoan tālā", "WST", "T", "https://restcountries.eu/data/wsm.svg", "");
INSERT INTO `manl_countries` VALUES("196", "San Marino", "san-marino", "SM", "SMR", "378", "City of San Marino", "Europe", "Southern Europe", "33005", "43.76666666,12.41666666", "Sammarinese", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/smr.svg", "");
INSERT INTO `manl_countries` VALUES("197", "Sao Tome and Principe", "sao-tome-and-principe", "ST", "STP", "239", "São Tomé", "Africa", "Middle Africa", "187356", "1,7", "Sao Tomean", "UTC", "São Tomé and Príncipe dobra", "STD", "Db", "https://restcountries.eu/data/stp.svg", "");
INSERT INTO `manl_countries` VALUES("198", "Saudi Arabia", "saudi-arabia", "SA", "SAU", "966", "Riyadh", "Asia", "Western Asia", "32248200", "25,45", "Saudi Arabian", "UTC+03:00", "Saudi riyal", "SAR", "ر.س", "https://restcountries.eu/data/sau.svg", "");
INSERT INTO `manl_countries` VALUES("199", "Senegal", "senegal", "SN", "SEN", "221", "Dakar", "Africa", "Western Africa", "14799859", "14,-14", "Senegalese", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/sen.svg", "");
INSERT INTO `manl_countries` VALUES("200", "Serbia", "serbia", "RS", "SRB", "381", "Belgrade", "Europe", "Southern Europe", "7076372", "44,21", "Serbian", "UTC+01:00", "Serbian dinar", "RSD", "дин", "https://restcountries.eu/data/srb.svg", "");
INSERT INTO `manl_countries` VALUES("201", "Seychelles", "seychelles", "SC", "SYC", "248", "Victoria", "Africa", "Eastern Africa", "91400", "-4.58333333,55.66666666", "Seychellois", "UTC+04:00", "Seychellois rupee", "SCR", "₨", "https://restcountries.eu/data/syc.svg", "");
INSERT INTO `manl_countries` VALUES("202", "Sierra Leone", "sierra-leone", "SL", "SLE", "232", "Freetown", "Africa", "Western Africa", "7075641", "8.5,-11.5", "Sierra Leonean", "UTC", "Sierra Leonean leone", "SLL", "Le", "https://restcountries.eu/data/sle.svg", "");
INSERT INTO `manl_countries` VALUES("203", "Singapore", "singapore", "SG", "SGP", "65", "Singapore", "Asia", "South-Eastern Asia", "5535000", "1.36666666,103.8", "Singaporean", "UTC+08:00", "Brunei dollar", "BND", "$", "https://restcountries.eu/data/sgp.svg", "");
INSERT INTO `manl_countries` VALUES("204", "Sint Maarten", "sint-maarten", "SX", "SXM", "1721", "Philipsburg", "Americas", "Caribbean", "38247", "18.033333,-63.05", "Dutch", "UTC-04:00", "Netherlands Antillean guilder", "ANG", "ƒ", "https://restcountries.eu/data/sxm.svg", "");
INSERT INTO `manl_countries` VALUES("205", "Slovakia", "slovakia", "SK", "SVK", "421", "Bratislava", "Europe", "Eastern Europe", "5426252", "48.66666666,19.5", "Slovak", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/svk.svg", "");
INSERT INTO `manl_countries` VALUES("206", "Slovenia", "slovenia", "SI", "SVN", "386", "Ljubljana", "Europe", "Southern Europe", "2064188", "46.11666666,14.81666666", "Slovene", "UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/svn.svg", "");
INSERT INTO `manl_countries` VALUES("207", "Solomon Islands", "solomon-islands", "SB", "SLB", "677", "Honiara", "Oceania", "Melanesia", "642000", "-8,159", "Solomon Islander", "UTC+11:00", "Solomon Islands dollar", "SBD", "$", "https://restcountries.eu/data/slb.svg", "");
INSERT INTO `manl_countries` VALUES("208", "Somalia", "somalia", "SO", "SOM", "252", "Mogadishu", "Africa", "Eastern Africa", "11079000", "10,49", "Somali", "UTC+03:00", "Somali shilling", "SOS", "Sh", "https://restcountries.eu/data/som.svg", "");
INSERT INTO `manl_countries` VALUES("209", "South Africa", "south-africa", "ZA", "ZAF", "27", "Pretoria", "Africa", "Southern Africa", "55653654", "-29,24", "South African", "UTC+02:00", "South African rand", "ZAR", "R", "https://restcountries.eu/data/zaf.svg", "");
INSERT INTO `manl_countries` VALUES("210", "South Georgia and the South Sandwich Islands", "south-georgia-and-the-south-sandwich-islands", "GS", "SGS", "500", "King Edward Point", "Americas", "South America", "30", "-54.5,-37", "South Georgia and the South Sandwich Islander", "UTC-02:00", "British pound", "GBP", "£", "https://restcountries.eu/data/sgs.svg", "");
INSERT INTO `manl_countries` VALUES("211", "South Korea", "south-korea", "KR", "KOR", "82", "Seoul", "Asia", "Eastern Asia", "50801405", "37,127.5", "South Korean", "UTC+09:00", "South Korean won", "KRW", "₩", "https://restcountries.eu/data/kor.svg", "");
INSERT INTO `manl_countries` VALUES("212", "South Sudan", "south-sudan", "SS", "SSD", "211", "Juba", "Africa", "Middle Africa", "12131000", "7,30", "South Sudanese", "UTC+03:00", "South Sudanese pound", "SSP", "£", "https://restcountries.eu/data/ssd.svg", "");
INSERT INTO `manl_countries` VALUES("213", "Spain", "spain", "ES", "ESP", "34", "Madrid", "Europe", "Southern Europe", "46438422", "40,-4", "Spanish", "UTC,UTC+01:00", "Euro", "EUR", "€", "https://restcountries.eu/data/esp.svg", "");
INSERT INTO `manl_countries` VALUES("214", "Sri Lanka", "sri-lanka", "LK", "LKA", "94", "Colombo", "Asia", "Southern Asia", "20966000", "7,81", "Sri Lankan", "UTC+05:30", "Sri Lankan rupee", "LKR", "Rs", "https://restcountries.eu/data/lka.svg", "");
INSERT INTO `manl_countries` VALUES("215", "Sudan", "sudan", "SD", "SDN", "249", "Khartoum", "Africa", "Northern Africa", "39598700", "15,30", "Sudanese", "UTC+03:00", "Sudanese pound", "SDG", "ج.س", "https://restcountries.eu/data/sdn.svg", "");
INSERT INTO `manl_countries` VALUES("216", "Suriname", "suriname", "SR", "SUR", "597", "Paramaribo", "Americas", "South America", "541638", "4,-56", "Surinamer", "UTC-03:00", "Surinamese dollar", "SRD", "$", "https://restcountries.eu/data/sur.svg", "");
INSERT INTO `manl_countries` VALUES("217", "Svalbard and Jan Mayen", "svalbard-and-jan-mayen", "SJ", "SJM", "4779", "Longyearbyen", "Europe", "Northern Europe", "2562", "78,20", "Norwegian", "UTC+01:00", "Norwegian krone", "NOK", "kr", "https://restcountries.eu/data/sjm.svg", "");
INSERT INTO `manl_countries` VALUES("218", "Swaziland", "swaziland", "SZ", "SWZ", "268", "Lobamba", "Africa", "Southern Africa", "1132657", "-26.5,31.5", "Swazi", "UTC+02:00", "Swazi lilangeni", "SZL", "L", "https://restcountries.eu/data/swz.svg", "");
INSERT INTO `manl_countries` VALUES("219", "Sweden", "sweden", "SE", "SWE", "46", "Stockholm", "Europe", "Northern Europe", "9894888", "62,15", "Swedish", "UTC+01:00", "Swedish krona", "SEK", "kr", "https://restcountries.eu/data/swe.svg", "");
INSERT INTO `manl_countries` VALUES("220", "Switzerland", "switzerland", "CH", "CHE", "41", "Bern", "Europe", "Western Europe", "8341600", "47,8", "Swiss", "UTC+01:00", "Swiss franc", "CHF", "Fr", "https://restcountries.eu/data/che.svg", "");
INSERT INTO `manl_countries` VALUES("221", "Syrian Arab Republic", "syrian-arab-republic", "SY", "SYR", "963", "Damascus", "Asia", "Western Asia", "18564000", "35,38", "Syrian", "UTC+02:00", "Syrian pound", "SYP", "£", "https://restcountries.eu/data/syr.svg", "");
INSERT INTO `manl_countries` VALUES("222", "Taiwan", "taiwan", "TW", "TWN", "886", "Taipei", "Asia", "Eastern Asia", "23503349", "23.5,121", "Taiwanese", "UTC+08:00", "New Taiwan dollar", "TWD", "$", "https://restcountries.eu/data/twn.svg", "");
INSERT INTO `manl_countries` VALUES("223", "Tajikistan", "tajikistan", "TJ", "TJK", "992", "Dushanbe", "Asia", "Central Asia", "8593600", "39,71", "Tadzhik", "UTC+05:00", "Tajikistani somoni", "TJS", "ЅМ", "https://restcountries.eu/data/tjk.svg", "");
INSERT INTO `manl_countries` VALUES("224", "Tanzania", "tanzania", "TZ", "TZA", "255", "Dodoma", "Africa", "Eastern Africa", "55155000", "-6,35", "Tanzanian", "UTC+03:00", "Tanzanian shilling", "TZS", "Sh", "https://restcountries.eu/data/tza.svg", "");
INSERT INTO `manl_countries` VALUES("225", "Thailand", "thailand", "TH", "THA", "66", "Bangkok", "Asia", "South-Eastern Asia", "65327652", "15,100", "Thai", "UTC+07:00", "Thai baht", "THB", "฿", "https://restcountries.eu/data/tha.svg", "");
INSERT INTO `manl_countries` VALUES("226", "Timor-Leste", "timor-leste", "TL", "TLS", "670", "Dili", "Asia", "South-Eastern Asia", "1167242", "-8.83333333,125.91666666", "East Timorese", "UTC+09:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/tls.svg", "");
INSERT INTO `manl_countries` VALUES("227", "Togo", "togo", "TG", "TGO", "228", "Lomé", "Africa", "Western Africa", "7143000", "8,1.16666666", "Togolese", "UTC", "West African CFA franc", "XOF", "Fr", "https://restcountries.eu/data/tgo.svg", "");
INSERT INTO `manl_countries` VALUES("228", "Tokelau", "tokelau", "TK", "TKL", "690", "Fakaofo", "Oceania", "Polynesia", "1411", "-9,-172", "Tokelauan", "UTC+13:00", "New Zealand dollar", "NZD", "$", "https://restcountries.eu/data/tkl.svg", "");
INSERT INTO `manl_countries` VALUES("229", "Tonga", "tonga", "TO", "TON", "676", "Nuku\'alofa", "Oceania", "Polynesia", "103252", "-20,-175", "Tongan", "UTC+13:00", "Tongan paʻanga", "TOP", "T$", "https://restcountries.eu/data/ton.svg", "");
INSERT INTO `manl_countries` VALUES("230", "Trinidad and Tobago", "trinidad-and-tobago", "TT", "TTO", "1868", "Port of Spain", "Americas", "Caribbean", "1349667", "11,-61", "Trinidadian", "UTC-04:00", "Trinidad and Tobago dollar", "TTD", "$", "https://restcountries.eu/data/tto.svg", "");
INSERT INTO `manl_countries` VALUES("231", "Tunisia", "tunisia", "TN", "TUN", "216", "Tunis", "Africa", "Northern Africa", "11154400", "34,9", "Tunisian", "UTC+01:00", "Tunisian dinar", "TND", "د.ت", "https://restcountries.eu/data/tun.svg", "");
INSERT INTO `manl_countries` VALUES("232", "Turkey", "turkey", "TR", "TUR", "90", "Ankara", "Asia", "Western Asia", "78741053", "39,35", "Turkish", "UTC+03:00", "Turkish lira", "TRY", "", "https://restcountries.eu/data/tur.svg", "");
INSERT INTO `manl_countries` VALUES("233", "Turkmenistan", "turkmenistan", "TM", "TKM", "993", "Ashgabat", "Asia", "Central Asia", "4751120", "40,60", "Turkmen", "UTC+05:00", "Turkmenistan manat", "TMT", "m", "https://restcountries.eu/data/tkm.svg", "");
INSERT INTO `manl_countries` VALUES("234", "Turks and Caicos Islands", "turks-and-caicos-islands", "TC", "TCA", "1649", "Cockburn Town", "Americas", "Caribbean", "31458", "21.75,-71.58333333", "Turks and Caicos Islander", "UTC-04:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/tca.svg", "");
INSERT INTO `manl_countries` VALUES("235", "Tuvalu", "tuvalu", "TV", "TUV", "688", "Funafuti", "Oceania", "Polynesia", "10640", "-8,178", "Tuvaluan", "UTC+12:00", "Australian dollar", "AUD", "$", "https://restcountries.eu/data/tuv.svg", "");
INSERT INTO `manl_countries` VALUES("236", "Uganda", "uganda", "UG", "UGA", "256", "Kampala", "Africa", "Eastern Africa", "33860700", "1,32", "Ugandan", "UTC+03:00", "Ugandan shilling", "UGX", "Sh", "https://restcountries.eu/data/uga.svg", "");
INSERT INTO `manl_countries` VALUES("237", "Ukraine", "ukraine", "UA", "UKR", "380", "Kiev", "Europe", "Eastern Europe", "42692393", "49,32", "Ukrainian", "UTC+02:00", "Ukrainian hryvnia", "UAH", "₴", "https://restcountries.eu/data/ukr.svg", "");
INSERT INTO `manl_countries` VALUES("238", "United Arab Emirates", "united-arab-emirates", "AE", "ARE", "971", "Abu Dhabi", "Asia", "Western Asia", "9856000", "24,54", "Emirati", "UTC+04", "United Arab Emirates dirham", "AED", "د.إ", "https://restcountries.eu/data/are.svg", "");
INSERT INTO `manl_countries` VALUES("239", "United Kingdom", "united-kingdom", "GB", "GBR", "44", "London", "Europe", "Northern Europe", "65110000", "54,-2", "British", "UTC-08:00,UTC-05:00,UTC-04:00,UTC-03:00,UTC-02:00,UTC,UTC+01:00,UTC+02:00,UTC+06:00", "British pound", "GBP", "£", "https://restcountries.eu/data/gbr.svg", "");
INSERT INTO `manl_countries` VALUES("240", "United States", "united-states", "US", "USA", "1", "Washington, D.C.", "Americas", "Northern America", "323947000", "38,-97", "American", "UTC-12:00,UTC-11:00,UTC-10:00,UTC-09:00,UTC-08:00,UTC-07:00,UTC-06:00,UTC-05:00,UTC-04:00,UTC+10:00,UTC+12:00", "United States dollar", "USD", "$", "https://restcountries.eu/data/usa.svg", "");
INSERT INTO `manl_countries` VALUES("241", "Uruguay", "uruguay", "UY", "URY", "598", "Montevideo", "Americas", "South America", "3480222", "-33,-56", "Uruguayan", "UTC-03:00", "Uruguayan peso", "UYU", "$", "https://restcountries.eu/data/ury.svg", "");
INSERT INTO `manl_countries` VALUES("242", "Uzbekistan", "uzbekistan", "UZ", "UZB", "998", "Tashkent", "Asia", "Central Asia", "31576400", "41,64", "Uzbekistani", "UTC+05:00", "Uzbekistani so\'m", "UZS", "", "https://restcountries.eu/data/uzb.svg", "");
INSERT INTO `manl_countries` VALUES("243", "Vanuatu", "vanuatu", "VU", "VUT", "678", "Port Vila", "Oceania", "Melanesia", "277500", "-16,167", "Ni-Vanuatu", "UTC+11:00", "Vanuatu vatu", "VUV", "Vt", "https://restcountries.eu/data/vut.svg", "");
INSERT INTO `manl_countries` VALUES("244", "Venezuela", "venezuela", "VE", "VEN", "58", "Caracas", "Americas", "South America", "31028700", "8,-66", "Venezuelan", "UTC-04:00", "Venezuelan bolívar", "VEF", "Bs ", "https://restcountries.eu/data/ven.svg", "");
INSERT INTO `manl_countries` VALUES("245", "Vietnam", "vietnam", "VN", "VNM", "84", "Hanoi", "Asia", "South-Eastern Asia", "92700000", "16.16666666,107.83333333", "Vietnamese", "UTC+07:00", "Vietnamese đồng", "VND", "₫", "https://restcountries.eu/data/vnm.svg", "");
INSERT INTO `manl_countries` VALUES("246", "Wallis and Futuna", "wallis-and-futuna", "WF", "WLF", "681", "Mata-Utu", "Oceania", "Polynesia", "11750", "-13.3,-176.2", "Wallis and Futuna Islander", "UTC+12:00", "CFP franc", "XPF", "Fr", "https://restcountries.eu/data/wlf.svg", "");
INSERT INTO `manl_countries` VALUES("247", "Western Sahara", "western-sahara", "EH", "ESH", "212", "El Aaiún", "Africa", "Northern Africa", "510713", "24.5,-13", "Sahrawi", "UTC+00:00", "Moroccan dirham", "MAD", "د.م", "https://restcountries.eu/data/esh.svg", "");
INSERT INTO `manl_countries` VALUES("248", "Yemen", "yemen", "YE", "YEM", "967", "Sana\'a", "Asia", "Western Asia", "27478000", "15,48", "Yemeni", "UTC+03:00", "Yemeni rial", "YER", "﷼", "https://restcountries.eu/data/yem.svg", "");
INSERT INTO `manl_countries` VALUES("249", "Zambia", "zambia", "ZM", "ZMB", "260", "Lusaka", "Africa", "Eastern Africa", "15933883", "-15,30", "Zambian", "UTC+02:00", "Zambian kwacha", "ZMW", "ZK", "https://restcountries.eu/data/zmb.svg", "");
INSERT INTO `manl_countries` VALUES("250", "Zimbabwe", "zimbabwe", "ZW", "ZWE", "263", "Harare", "Africa", "Eastern Africa", "14240168", "-20,30", "Zimbabwean", "UTC+02:00", "Botswana pula", "BWP", "P", "https://restcountries.eu/data/zwe.svg", "");

/* INSERT TABLE DATA: manl_duplicator_packages */
INSERT INTO `manl_duplicator_packages` VALUES("2", "20210119_museumassociationofnewfoundl", "96b93605719c3eaa2813_20210119023512", "21", "2021-01-19 02:35:23", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-01-19 02:35:12\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:3:\"5.6\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:37:\"20210119_museumassociationofnewfoundl\";s:4:\"Hash\";s:35:\"96b93605719c3eaa2813_20210119023512\";s:8:\"NameHash\";s:73:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";s:85:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home/mdcgroup/public_html/dev.mdcis.com/manl\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-01-19 02:35:12\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:3:\"5.6\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20210119_museumassociationofnewfoundl\";s:4:\"Hash\";s:35:\"96b93605719c3eaa2813_20210119023512\";s:8:\"NameHash\";s:73:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:87:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:9:\"localhost\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:17:\"museumsnl_website\";s:10:\"OptsDBUser\";s:17:\"museumsnl_webUser\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:7:{s:28:\"manl_actionscheduler_actions\";s:1:\"0\";s:27:\"manl_actionscheduler_claims\";s:1:\"0\";s:27:\"manl_actionscheduler_groups\";s:1:\"0\";s:25:\"manl_actionscheduler_logs\";s:1:\"0\";s:16:\"manl_commentmeta\";s:3:\"112\";s:13:\"manl_comments\";s:2:\"19\";s:14:\"manl_countries\";s:3:\"250\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:164:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/backups-dup-lite/tmp/20210119_museumassociationofnewfoundl_96b93605719c3eaa2813_20210119023512_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:54:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-admin\";i:1;s:64:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/uploads\";i:2;s:66:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/languages\";i:3;s:63:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/themes\";i:4;s:57:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:45:\"/home/mdcgroup/public_html/dev.mdcis.com/manl\";i:1;s:56:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:96;s:13:\"BuildProgress\";r:134;}");

/* INSERT TABLE DATA: manl_geodir_attachments */
INSERT INTO `manl_geodir_attachments` VALUES("1", "1214", "2020-02-22 02:45:46", "1", "0", "", "", "/2020/02/a1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:14:\"2020/02/a1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("2", "1214", "2020-02-22 02:45:46", "1", "0", "", "", "/2020/02/a2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:14:\"2020/02/a2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("3", "1214", "2020-02-22 02:45:46", "1", "0", "", "", "/2020/02/a3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:14:\"2020/02/a3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("4", "1214", "2020-02-22 02:45:46", "1", "0", "", "", "/2020/02/a4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:14:\"2020/02/a4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("5", "1214", "2020-02-22 02:45:46", "1", "0", "", "", "/2020/02/a5.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:14:\"2020/02/a5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a5-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("6", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:14:\"2020/02/a6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("7", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:14:\"2020/02/a7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("8", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:14:\"2020/02/a8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("9", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:14:\"2020/02/a9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"a9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"a9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:14:\"a9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:14:\"a9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:14:\"a9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("10", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a10.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("11", "1214", "2020-02-22 02:45:47", "1", "0", "", "", "/2020/02/a11.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a11.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a11-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a11-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a11-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("12", "1216", "2020-02-22 02:45:49", "1", "0", "", "", "/2020/02/a6-1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("13", "1216", "2020-02-22 02:45:49", "1", "0", "", "", "/2020/02/a1-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("14", "1216", "2020-02-22 02:45:49", "1", "0", "", "", "/2020/02/a3-1.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("15", "1216", "2020-02-22 02:45:49", "1", "0", "", "", "/2020/02/a4-1.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("16", "1216", "2020-02-22 02:45:49", "1", "0", "", "", "/2020/02/a5-1.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-1-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("17", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a2-1.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("18", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a7-1.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("19", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a8-1.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("20", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a9-1.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("21", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a10-1.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a10-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a10-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a10-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a10-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a10-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a10-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("22", "1216", "2020-02-22 02:45:50", "1", "0", "", "", "/2020/02/a11-1.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a11-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a11-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a11-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a11-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a11-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a11-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("23", "1218", "2020-02-22 02:45:52", "1", "0", "", "", "/2020/02/a9-2.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("24", "1218", "2020-02-22 02:45:52", "1", "0", "", "", "/2020/02/a10-2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a10-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a10-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a10-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a10-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a10-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a10-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("25", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a3-2.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("26", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a4-2.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("27", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a5-2.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-2-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("28", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a2-2.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("29", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a7-2.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("30", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a8-2.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("31", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a6-2.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("32", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a1-2.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("33", "1218", "2020-02-22 02:45:53", "1", "0", "", "", "/2020/02/a11-2.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a11-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a11-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a11-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a11-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a11-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a11-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("34", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a11-3.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a11-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a11-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a11-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a11-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a11-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a11-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("35", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a10-3.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a10-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a10-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a10-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a10-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a10-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a10-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("36", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a3-3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("37", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a4-3.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("38", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a5-3.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-3-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("39", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a2-3.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("40", "1220", "2020-02-22 02:45:56", "1", "0", "", "", "/2020/02/a7-3.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("41", "1220", "2020-02-22 02:45:57", "1", "0", "", "", "/2020/02/a8-3.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("42", "1220", "2020-02-22 02:45:57", "1", "0", "", "", "/2020/02/a6-3.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("43", "1220", "2020-02-22 02:45:57", "1", "0", "", "", "/2020/02/a1-3.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("44", "1220", "2020-02-22 02:45:57", "1", "0", "", "", "/2020/02/a9-3.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("45", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a12.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a12-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a12-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a12-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("46", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a13.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a13.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a13-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a13-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a13-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a13-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("47", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a3-4.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("48", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a4-4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("49", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a5-4.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-4-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("50", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a2-4.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("51", "1222", "2020-02-22 02:45:59", "1", "0", "", "", "/2020/02/a7-4.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("52", "1222", "2020-02-22 02:46:00", "1", "0", "", "", "/2020/02/a8-4.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("53", "1222", "2020-02-22 02:46:00", "1", "0", "", "", "/2020/02/a6-4.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("54", "1222", "2020-02-22 02:46:00", "1", "0", "", "", "/2020/02/a1-4.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("55", "1222", "2020-02-22 02:46:00", "1", "0", "", "", "/2020/02/a9-4.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("56", "1224", "2020-02-22 02:46:02", "1", "0", "", "", "/2020/02/a14.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:15:\"2020/02/a14.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a14-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a14-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a14-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a14-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("57", "1224", "2020-02-22 02:46:02", "1", "0", "", "", "/2020/02/a13-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a13-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a13-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a13-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a13-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a13-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a13-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("58", "1224", "2020-02-22 02:46:02", "1", "0", "", "", "/2020/02/a3-5.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("59", "1224", "2020-02-22 02:46:02", "1", "0", "", "", "/2020/02/a4-5.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("60", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a5-5.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-5-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("61", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a2-5.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("62", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a7-5.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("63", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a8-5.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("64", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a6-5.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("65", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a1-5.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("66", "1224", "2020-02-22 02:46:03", "1", "0", "", "", "/2020/02/a9-5.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("67", "1226", "2020-02-22 02:46:05", "1", "0", "", "", "/2020/02/a15.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:15:\"2020/02/a15.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a15-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a15-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a15-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a15-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("68", "1226", "2020-02-22 02:46:06", "1", "0", "", "", "/2020/02/a16.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:15:\"2020/02/a16.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a16-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a16-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a16-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a16-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("69", "1226", "2020-02-22 02:46:06", "1", "0", "", "", "/2020/02/a17.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:15:\"2020/02/a17.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a17-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a17-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a17-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a17-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("70", "1226", "2020-02-22 02:46:06", "1", "0", "", "", "/2020/02/a4-6.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("71", "1226", "2020-02-22 02:46:06", "1", "0", "", "", "/2020/02/a5-6.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-6-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("72", "1226", "2020-02-22 02:46:06", "1", "0", "", "", "/2020/02/a2-6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("73", "1226", "2020-02-22 02:46:07", "1", "0", "", "", "/2020/02/a7-6.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("74", "1226", "2020-02-22 02:46:07", "1", "0", "", "", "/2020/02/a8-6.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("75", "1226", "2020-02-22 02:46:07", "1", "0", "", "", "/2020/02/a6-6.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("76", "1226", "2020-02-22 02:46:07", "1", "0", "", "", "/2020/02/a1-6.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("77", "1226", "2020-02-22 02:46:07", "1", "0", "", "", "/2020/02/a9-6.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("78", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a18.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:15:\"2020/02/a18.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a18-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a18-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a18-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a18-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("79", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a10-4.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a10-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a10-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a10-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a10-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a10-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a10-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("80", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a3-6.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("81", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a4-7.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("82", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a5-7.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-7-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("83", "1228", "2020-02-22 02:46:09", "1", "0", "", "", "/2020/02/a2-7.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("84", "1228", "2020-02-22 02:46:10", "1", "0", "", "", "/2020/02/a7-7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("85", "1228", "2020-02-22 02:46:10", "1", "0", "", "", "/2020/02/a8-7.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("86", "1228", "2020-02-22 02:46:10", "1", "0", "", "", "/2020/02/a6-7.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("87", "1228", "2020-02-22 02:46:10", "1", "0", "", "", "/2020/02/a1-7.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("88", "1228", "2020-02-22 02:46:10", "1", "0", "", "", "/2020/02/a9-7.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("89", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a19.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a19.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a19-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a19-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a19-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a19-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("90", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a20.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:15:\"2020/02/a20.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a20-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:15:\"a20-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:15:\"a20-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"a20-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("91", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a3-7.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("92", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a4-8.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("93", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a5-8.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-8-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("94", "1230", "2020-02-22 02:46:12", "1", "0", "", "", "/2020/02/a2-8.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("95", "1230", "2020-02-22 02:46:13", "1", "0", "", "", "/2020/02/a7-8.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("96", "1230", "2020-02-22 02:46:13", "1", "0", "", "", "/2020/02/a8-8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("97", "1230", "2020-02-22 02:46:13", "1", "0", "", "", "/2020/02/a6-8.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("98", "1230", "2020-02-22 02:46:13", "1", "0", "", "", "/2020/02/a1-8.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("99", "1230", "2020-02-22 02:46:13", "1", "0", "", "", "/2020/02/a9-8.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("100", "1232", "2020-02-22 02:46:15", "1", "0", "", "", "/2020/02/a19-1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a19-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a19-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a19-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a19-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a19-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a19-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("101", "1232", "2020-02-22 02:46:15", "1", "0", "", "", "/2020/02/a20-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:17:\"2020/02/a20-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"a20-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"a20-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:17:\"a20-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:17:\"a20-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"a20-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("102", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a3-8.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a3-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a3-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a3-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a3-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a3-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a3-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("103", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a4-9.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a4-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a4-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a4-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a4-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a4-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a4-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("104", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a5-9.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:396;s:4:\"file\";s:16:\"2020/02/a5-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a5-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a5-9-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a5-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a5-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a5-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("105", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a2-9.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a2-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a2-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a2-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a2-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a2-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a2-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("106", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a7-9.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a7-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a7-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a7-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a7-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a7-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a7-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("107", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a8-9.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a8-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a8-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a8-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a8-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a8-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a8-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("108", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a6-9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:16:\"2020/02/a6-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a6-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a6-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a6-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a6-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a6-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("109", "1232", "2020-02-22 02:46:16", "1", "0", "", "", "/2020/02/a1-9.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a1-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a1-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a1-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a1-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a1-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a1-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("110", "1232", "2020-02-22 02:46:17", "1", "0", "", "", "/2020/02/a9-9.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:16:\"2020/02/a9-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"a9-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"a9-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:16:\"a9-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:16:\"a9-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:16:\"a9-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("111", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("112", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("113", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("114", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("115", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels5.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("116", "1234", "2020-02-22 02:46:19", "1", "0", "", "", "/2020/02/hotels6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("117", "1234", "2020-02-22 02:46:20", "1", "0", "", "", "/2020/02/hotels7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("118", "1234", "2020-02-22 02:46:20", "1", "0", "", "", "/2020/02/hotels8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("119", "1234", "2020-02-22 02:46:20", "1", "0", "", "", "/2020/02/hotels9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:19:\"2020/02/hotels9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"hotels9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"hotels9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:19:\"hotels9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:19:\"hotels9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"hotels9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("120", "1234", "2020-02-22 02:46:20", "1", "0", "", "", "/2020/02/hotels10.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("121", "1234", "2020-02-22 02:46:21", "1", "0", "", "", "/2020/02/hotels11.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels11.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels11-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels11-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels11-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("122", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels5-1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels5-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels5-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels5-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels5-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels5-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels5-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("123", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels2-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("124", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels3-1.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels3-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels3-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels3-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels3-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels3-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("125", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels4-1.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("126", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels1-1.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("127", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels6-1.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("128", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels7-1.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("129", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels8-1.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("130", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels9-1.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("131", "1236", "2020-02-22 02:46:23", "1", "0", "", "", "/2020/02/hotels10-1.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("132", "1236", "2020-02-22 02:46:24", "1", "0", "", "", "/2020/02/hotels11-1.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels11-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels11-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels11-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels11-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels11-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels11-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("133", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels10-2.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("134", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels11-2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels11-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels11-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels11-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels11-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels11-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels11-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("135", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels12.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels12-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels12-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels12-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("136", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels4-2.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("137", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels1-2.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("138", "1238", "2020-02-22 02:46:26", "1", "0", "", "", "/2020/02/hotels6-2.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("139", "1238", "2020-02-22 02:46:27", "1", "0", "", "", "/2020/02/hotels7-2.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("140", "1238", "2020-02-22 02:46:27", "1", "0", "", "", "/2020/02/hotels8-2.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("141", "1238", "2020-02-22 02:46:27", "1", "0", "", "", "/2020/02/hotels9-2.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("142", "1238", "2020-02-22 02:46:27", "1", "0", "", "", "/2020/02/hotels1-3.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("143", "1238", "2020-02-22 02:46:27", "1", "0", "", "", "/2020/02/hotels2-2.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("144", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels15.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels15.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels15-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels15-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels15-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels15-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("145", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels16.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels16.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels16-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels16-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels16-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels16-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("146", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels12-1.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("147", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels4-3.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("148", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels1-4.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("149", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels6-3.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("150", "1240", "2020-02-22 02:46:29", "1", "0", "", "", "/2020/02/hotels7-3.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("151", "1240", "2020-02-22 02:46:30", "1", "0", "", "", "/2020/02/hotels8-3.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("152", "1240", "2020-02-22 02:46:30", "1", "0", "", "", "/2020/02/hotels9-3.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("153", "1240", "2020-02-22 02:46:30", "1", "0", "", "", "/2020/02/hotels1-5.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("154", "1240", "2020-02-22 02:46:30", "1", "0", "", "", "/2020/02/hotels2-3.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("155", "1242", "2020-02-22 02:46:32", "1", "0", "", "", "/2020/02/hotels10-3.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("156", "1242", "2020-02-22 02:46:32", "1", "0", "", "", "/2020/02/hotels16-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels16-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels16-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels16-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels16-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels16-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels16-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("157", "1242", "2020-02-22 02:46:32", "1", "0", "", "", "/2020/02/hotels12-2.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("158", "1242", "2020-02-22 02:46:32", "1", "0", "", "", "/2020/02/hotels4-4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("159", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels1-6.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("160", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels6-4.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("161", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels7-4.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("162", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels8-4.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("163", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels9-4.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("164", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels1-7.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("165", "1242", "2020-02-22 02:46:33", "1", "0", "", "", "/2020/02/hotels2-4.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("166", "1244", "2020-02-22 02:46:35", "1", "0", "", "", "/2020/02/hotels17.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels17.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels17-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels17-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels17-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels17-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("167", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels18.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:20:\"2020/02/hotels18.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"hotels18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"hotels18-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:20:\"hotels18-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:20:\"hotels18-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"hotels18-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("168", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels12-3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("169", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels4-5.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("170", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels1-8.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("171", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels6-5.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("172", "1244", "2020-02-22 02:46:36", "1", "0", "", "", "/2020/02/hotels7-5.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("173", "1244", "2020-02-22 02:46:37", "1", "0", "", "", "/2020/02/hotels8-5.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("174", "1244", "2020-02-22 02:46:37", "1", "0", "", "", "/2020/02/hotels9-5.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("175", "1244", "2020-02-22 02:46:37", "1", "0", "", "", "/2020/02/hotels1-9.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels1-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels1-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels1-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels1-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels1-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels1-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("176", "1244", "2020-02-22 02:46:37", "1", "0", "", "", "/2020/02/hotels2-5.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("177", "1246", "2020-02-22 02:46:39", "1", "0", "", "", "/2020/02/hotels11-3.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels11-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels11-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels11-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels11-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels11-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels11-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("178", "1246", "2020-02-22 02:46:39", "1", "0", "", "", "/2020/02/hotels10-4.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("179", "1246", "2020-02-22 02:46:39", "1", "0", "", "", "/2020/02/hotels12-4.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("180", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels4-6.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("181", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels1-10.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("182", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels6-6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("183", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels7-6.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("184", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels8-6.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("185", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels9-6.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("186", "1246", "2020-02-22 02:46:40", "1", "0", "", "", "/2020/02/hotels1-11.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-11.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-11-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-11-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-11-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("187", "1246", "2020-02-22 02:46:41", "1", "0", "", "", "/2020/02/hotels2-6.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("188", "1248", "2020-02-22 02:46:43", "1", "0", "", "", "/2020/02/hotels11-4.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels11-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels11-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels11-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels11-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels11-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels11-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("189", "1248", "2020-02-22 02:46:43", "1", "0", "", "", "/2020/02/hotels10-5.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("190", "1248", "2020-02-22 02:46:43", "1", "0", "", "", "/2020/02/hotels12-5.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("191", "1248", "2020-02-22 02:46:43", "1", "0", "", "", "/2020/02/hotels4-7.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("192", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels1-12.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-12-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-12-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-12-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("193", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels6-7.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("194", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels7-7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("195", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels8-7.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("196", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels9-7.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("197", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels1-13.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-13.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-13-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-13-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-13-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-13-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("198", "1248", "2020-02-22 02:46:44", "1", "0", "", "", "/2020/02/hotels2-7.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("199", "1250", "2020-02-22 02:46:46", "1", "0", "", "", "/2020/02/hotels5-2.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels5-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels5-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels5-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels5-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels5-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels5-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("200", "1250", "2020-02-22 02:46:46", "1", "0", "", "", "/2020/02/hotels10-6.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("201", "1250", "2020-02-22 02:46:46", "1", "0", "", "", "/2020/02/hotels12-6.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("202", "1250", "2020-02-22 02:46:46", "1", "0", "", "", "/2020/02/hotels4-8.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("203", "1250", "2020-02-22 02:46:46", "1", "0", "", "", "/2020/02/hotels1-14.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-14.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-14-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-14-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-14-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-14-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("204", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels6-8.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("205", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels7-8.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("206", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels8-8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("207", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels9-8.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("208", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels1-15.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-15.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-15-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-15-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-15-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-15-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("209", "1250", "2020-02-22 02:46:47", "1", "0", "", "", "/2020/02/hotels2-8.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("210", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels7-9.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels7-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels7-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels7-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels7-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels7-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels7-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("211", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels10-7.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels10-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels10-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels10-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels10-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels10-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels10-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("212", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels12-7.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("213", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels4-9.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels4-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels4-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels4-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels4-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels4-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels4-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("214", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels1-16.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-16.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-16-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-16-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-16-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-16-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("215", "1252", "2020-02-22 02:46:49", "1", "0", "", "", "/2020/02/hotels6-9.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels6-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels6-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels6-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels6-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels6-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels6-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("216", "1252", "2020-02-22 02:46:50", "1", "0", "", "", "/2020/02/hotels12-8.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels12-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels12-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels12-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels12-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels12-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels12-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("217", "1252", "2020-02-22 02:46:50", "1", "0", "", "", "/2020/02/hotels8-9.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels8-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels8-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels8-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels8-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels8-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels8-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("218", "1252", "2020-02-22 02:46:50", "1", "0", "", "", "/2020/02/hotels9-9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels9-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels9-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels9-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels9-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels9-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels9-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("219", "1252", "2020-02-22 02:46:50", "1", "0", "", "", "/2020/02/hotels1-17.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:22:\"2020/02/hotels1-17.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"hotels1-17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"hotels1-17-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:22:\"hotels1-17-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:22:\"hotels1-17-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:22:\"hotels1-17-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("220", "1252", "2020-02-22 02:46:50", "1", "0", "", "", "/2020/02/hotels2-9.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2020/02/hotels2-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hotels2-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hotels2-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:21:\"hotels2-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:21:\"hotels2-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"hotels2-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("221", "1254", "2020-02-22 02:46:52", "1", "0", "", "", "/2020/02/restaurants1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("222", "1254", "2020-02-22 02:46:52", "1", "0", "", "", "/2020/02/restaurants2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("223", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("224", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("225", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants5.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("226", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:24:\"2020/02/restaurants6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("227", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:24:\"2020/02/restaurants7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("228", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:24:\"2020/02/restaurants8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("229", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:24:\"2020/02/restaurants9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"restaurants9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"restaurants9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:24:\"restaurants9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:24:\"restaurants9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:24:\"restaurants9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("230", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants10.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:25:\"2020/02/restaurants10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("231", "1254", "2020-02-22 02:46:53", "1", "0", "", "", "/2020/02/restaurants11.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:25:\"2020/02/restaurants11.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants11-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants11-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants11-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("232", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants4-1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("233", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants2-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("234", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants3-1.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants3-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants3-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants3-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants3-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants3-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("235", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants1-1.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants1-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants1-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants1-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants1-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants1-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("236", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants5-1.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("237", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants6-1.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("238", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants7-1.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("239", "1256", "2020-02-22 02:46:56", "1", "0", "", "", "/2020/02/restaurants8-1.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("240", "1256", "2020-02-22 02:46:57", "1", "0", "", "", "/2020/02/restaurants9-1.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("241", "1256", "2020-02-22 02:46:57", "1", "0", "", "", "/2020/02/restaurants10-1.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants10-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants10-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants10-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants10-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants10-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants10-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("242", "1256", "2020-02-22 02:46:57", "1", "0", "", "", "/2020/02/restaurants11-1.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants11-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants11-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants11-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants11-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants11-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants11-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("243", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants5-2.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("244", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants6-2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("245", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants7-2.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("246", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants1-2.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants1-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants1-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants1-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants1-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants1-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("247", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants2-2.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("248", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants3-2.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants3-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants3-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants3-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants3-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants3-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants3-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("249", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants4-2.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("250", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants8-2.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("251", "1258", "2020-02-22 02:46:59", "1", "0", "", "", "/2020/02/restaurants9-2.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("252", "1258", "2020-02-22 02:47:00", "1", "0", "", "", "/2020/02/restaurants10-2.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants10-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants10-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants10-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants10-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants10-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants10-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("253", "1258", "2020-02-22 02:47:00", "1", "0", "", "", "/2020/02/restaurants11-2.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants11-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants11-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants11-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants11-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants11-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants11-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("254", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants9-3.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("255", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants10-3.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants10-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants10-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants10-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants10-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants10-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants10-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("256", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants3-3.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants3-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants3-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants3-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants3-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants3-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants3-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("257", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants1-3.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants1-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants1-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants1-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants1-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants1-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants1-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("258", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants5-3.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("259", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants6-3.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("260", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants7-3.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("261", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants8-3.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("262", "1260", "2020-02-22 02:47:02", "1", "0", "", "", "/2020/02/restaurants9-4.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("263", "1260", "2020-02-22 02:47:03", "1", "0", "", "", "/2020/02/restaurants2-3.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("264", "1260", "2020-02-22 02:47:03", "1", "0", "", "", "/2020/02/restaurants4-3.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("265", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants4-4.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("266", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants10-4.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants10-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants10-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants10-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants10-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants10-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants10-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("267", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants3-4.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants3-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants3-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants3-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants3-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants3-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants3-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("268", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants1-4.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants1-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants1-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants1-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants1-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants1-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants1-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("269", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants5-4.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("270", "1262", "2020-02-22 02:47:05", "1", "0", "", "", "/2020/02/restaurants6-4.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("271", "1262", "2020-02-22 02:47:06", "1", "0", "", "", "/2020/02/restaurants7-4.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("272", "1262", "2020-02-22 02:47:06", "1", "0", "", "", "/2020/02/restaurants8-4.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("273", "1262", "2020-02-22 02:47:06", "1", "0", "", "", "/2020/02/restaurants9-5.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("274", "1262", "2020-02-22 02:47:06", "1", "0", "", "", "/2020/02/restaurants2-4.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-4-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("275", "1262", "2020-02-22 02:47:06", "1", "0", "", "", "/2020/02/restaurants4-5.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("276", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants11-3.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants11-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants11-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants11-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants11-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants11-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants11-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("277", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants10-5.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants10-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants10-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants10-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants10-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants10-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants10-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("278", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants3-5.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants3-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants3-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants3-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants3-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants3-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants3-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("279", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants1-5.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants1-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants1-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants1-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants1-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants1-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants1-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("280", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants5-5.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("281", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants6-5.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("282", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants7-5.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("283", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants8-5.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("284", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants9-6.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("285", "1264", "2020-02-22 02:47:09", "1", "0", "", "", "/2020/02/restaurants2-5.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-5-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-5-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("286", "1264", "2020-02-22 02:47:10", "1", "0", "", "", "/2020/02/restaurants4-6.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("287", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants12.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants12-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants12-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants12-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("288", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants13.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants13.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants13-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants13-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants13-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants13-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("289", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants14.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants14.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants14-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants14-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants14-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants14-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("290", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants15.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants15.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants15-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants15-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants15-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants15-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("291", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants5-6.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("292", "1266", "2020-02-22 02:47:12", "1", "0", "", "", "/2020/02/restaurants6-6.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("293", "1266", "2020-02-22 02:47:13", "1", "0", "", "", "/2020/02/restaurants7-6.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("294", "1266", "2020-02-22 02:47:13", "1", "0", "", "", "/2020/02/restaurants8-6.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("295", "1266", "2020-02-22 02:47:13", "1", "0", "", "", "/2020/02/restaurants9-7.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("296", "1266", "2020-02-22 02:47:13", "1", "0", "", "", "/2020/02/restaurants2-6.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-6-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-6-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("297", "1266", "2020-02-22 02:47:13", "1", "0", "", "", "/2020/02/restaurants4-7.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("298", "1268", "2020-02-22 02:47:15", "1", "0", "", "", "/2020/02/restaurants16.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants16.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants16-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants16-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants16-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants16-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("299", "1268", "2020-02-22 02:47:15", "1", "0", "", "", "/2020/02/restaurants17.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants17.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants17-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants17-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants17-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants17-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("300", "1268", "2020-02-22 02:47:15", "1", "0", "", "", "/2020/02/restaurants18.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants18.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants18-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants18-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants18-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants18-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("301", "1268", "2020-02-22 02:47:15", "1", "0", "", "", "/2020/02/restaurants19.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:25:\"2020/02/restaurants19.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"restaurants19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"restaurants19-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:25:\"restaurants19-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:25:\"restaurants19-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:25:\"restaurants19-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("302", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants5-7.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("303", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants6-7.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("304", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants7-7.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("305", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants8-7.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("306", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants9-8.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("307", "1268", "2020-02-22 02:47:16", "1", "0", "", "", "/2020/02/restaurants2-7.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-7-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-7-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("308", "1268", "2020-02-22 02:47:17", "1", "0", "", "", "/2020/02/restaurants4-8.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("309", "1270", "2020-02-22 02:47:19", "1", "0", "", "", "/2020/02/restaurants17-1.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants17-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants17-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants17-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants17-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants17-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants17-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("310", "1270", "2020-02-22 02:47:19", "1", "0", "", "", "/2020/02/restaurants16-1.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants16-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants16-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants16-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants16-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants16-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants16-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("311", "1270", "2020-02-22 02:47:19", "1", "0", "", "", "/2020/02/restaurants18-1.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants18-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants18-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants18-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants18-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants18-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants18-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("312", "1270", "2020-02-22 02:47:19", "1", "0", "", "", "/2020/02/restaurants19-1.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants19-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants19-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants19-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants19-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants19-1-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants19-1-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("313", "1270", "2020-02-22 02:47:19", "1", "0", "", "", "/2020/02/restaurants5-8.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("314", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants6-8.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("315", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants7-8.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("316", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants8-8.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("317", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants9-9.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants9-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants9-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants9-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants9-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants9-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants9-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("318", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants2-8.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-8-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-8-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("319", "1270", "2020-02-22 02:47:20", "1", "0", "", "", "/2020/02/restaurants4-9.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants4-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants4-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants4-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants4-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants4-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants4-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("320", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants19-2.jpg", "image/jpeg", "0", "1", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants19-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants19-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants19-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants19-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants19-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants19-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("321", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants17-2.jpg", "image/jpeg", "1", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants17-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants17-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants17-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants17-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants17-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants17-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("322", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants18-2.jpg", "image/jpeg", "2", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants18-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants18-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants18-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants18-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants18-2-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants18-2-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("323", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants19-3.jpg", "image/jpeg", "3", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:27:\"2020/02/restaurants19-3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants19-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants19-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants19-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants19-3-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants19-3-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("324", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants5-9.jpg", "image/jpeg", "4", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants5-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants5-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants5-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants5-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants5-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants5-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("325", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants6-9.jpg", "image/jpeg", "5", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants6-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants6-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants6-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants6-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants6-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants6-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("326", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants7-9.jpg", "image/jpeg", "6", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants7-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants7-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants7-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants7-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants7-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants7-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("327", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants8-9.jpg", "image/jpeg", "7", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:386;s:4:\"file\";s:26:\"2020/02/restaurants8-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants8-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants8-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants8-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants8-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants8-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("328", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants9-10.jpg", "image/jpeg", "8", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants9-10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants9-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants9-10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants9-10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants9-10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants9-10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("329", "1272", "2020-02-22 02:47:23", "1", "0", "", "", "/2020/02/restaurants2-9.jpg", "image/jpeg", "9", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:26:\"2020/02/restaurants2-9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"restaurants2-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"restaurants2-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:26:\"restaurants2-9-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:26:\"restaurants2-9-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"restaurants2-9-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");
INSERT INTO `manl_geodir_attachments` VALUES("330", "1272", "2020-02-22 02:47:24", "1", "0", "", "", "/2020/02/restaurants4-10.jpg", "image/jpeg", "10", "0", "1", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:387;s:4:\"file\";s:27:\"2020/02/restaurants4-10.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"restaurants4-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"restaurants4-10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_100x100\";a:4:{s:4:\"file\";s:27:\"restaurants4-10-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"imic_210x210\";a:4:{s:4:\"file\";s:27:\"restaurants4-10-210x210.jpg\";s:5:\"width\";i:210;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"restaurants4-10-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}", "post_images");

/* INSERT TABLE DATA: manl_geodir_custom_fields */
INSERT INTO `manl_geodir_custom_fields` VALUES("1", "gd_place", "VARCHAR", "text", "text", "Title", "Enter the title.", "Place Title", "post_title", "", "", "1", "0", "0", "", "Title", "1", "1", "1", "", "[mapbubble]", "0", "", "0", "0", "", "fas fa-minus", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("2", "gd_place", "TEXT", "textarea", "textarea", "Description", "Enter a description", "Place Description", "post_content", "", "", "2", "0", "0", "", "Description", "1", "1", "1", "", "", "0", "", "0", "0", "", "fas fa-minus", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("3", "gd_place", "TEXT", "tags", "tags", "Tags", "Tags are short keywords, with no space within.(eg: tag1, tag2, tag3).", "Tags", "post_tags", "", "", "3", "0", "0", "", "Tags", "1", "1", "0", "", "[detail]", "0", "", "0", "0", "", "fas fa-tags", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("4", "gd_place", "VARCHAR", "categories", "categories", "Category", "SELECT listing category FROM here. SELECT at least one CATEGORY", "Category", "post_category", "", "", "4", "0", "0", "", "Category", "1", "1", "1", "", "[detail]", "0", "", "0", "0", "a:1:{s:16:\"cat_display_type\";s:11:\"multiselect\";}", "fas fa-folder-open", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("5", "gd_place", "VARCHAR", "address", "address", "Address", "Please enter the listing street address. eg. : 230 Vine Street", "Address", "address", "", "", "5", "0", "0", "", "Address", "1", "1", "1", "Address fields are required", "[detail],[mapbubble]", "0", "", "0", "0", "a:15:{s:9:\"show_city\";s:1:\"1\";s:10:\"city_lable\";s:4:\"City\";s:11:\"show_region\";s:1:\"1\";s:12:\"region_lable\";s:6:\"Region\";s:12:\"show_country\";s:1:\"1\";s:13:\"country_lable\";s:7:\"Country\";s:8:\"show_zip\";s:1:\"1\";s:9:\"zip_lable\";s:13:\"Zip/Post Code\";s:8:\"show_map\";s:1:\"1\";s:9:\"map_lable\";s:18:\"Set Address On Map\";s:12:\"show_mapview\";s:1:\"1\";s:13:\"mapview_lable\";s:15:\"Select Map View\";s:12:\"show_mapzoom\";s:1:\"1\";s:13:\"mapzoom_lable\";s:6:\"hidden\";s:11:\"show_latlng\";s:1:\"1\";}", "fas fa-map-marker-alt", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("6", "gd_place", "TEXT", "images", "images", "Images", "You can upload more than one image to create a image gallery on the details page.", "Images", "post_images", "", "", "6", "0", "0", "", "Images", "1", "1", "0", "", "", "0", "", "0", "0", "", "far fa-image", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("7", "gd_place", "VARCHAR", "phone", "phone", "Phone", "You can enter phone number,cell phone number etc.", "Phone", "phone", "", "", "7", "0", "0", "", "Phone", "1", "0", "0", "", "[detail],[mapbubble]", "0", "", "0", "0", "", "", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("8", "gd_place", "VARCHAR", "email", "email", "Email", "You can enter your business or listing email.", "Email", "email", "", "", "8", "0", "0", "", "Email", "1", "0", "0", "", "[detail]", "0", "", "0", "0", "", "", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("9", "gd_place", "TEXT", "url", "url", "Website", "You can enter your business or listing website.", "Website", "website", "", "", "9", "0", "0", "", "Website", "1", "0", "0", "", "[detail]", "0", "", "0", "0", "", "", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("10", "gd_place", "TEXT", "url", "url", "Twitter", "You can enter your business or listing twitter url.", "Twitter", "twitter", "", "", "10", "0", "0", "", "Twitter", "1", "0", "0", "", "[detail]", "0", "", "0", "0", "", "", "", "0", "", "");
INSERT INTO `manl_geodir_custom_fields` VALUES("11", "gd_place", "TEXT", "url", "url", "Facebook", "You can enter your business or listing facebook url.", "Facebook", "facebook", "", "", "11", "0", "0", "", "Facebook", "1", "0", "0", "", "[detail]", "0", "", "0", "0", "", "", "", "0", "", "");

/* INSERT TABLE DATA: manl_geodir_custom_sort_fields */
INSERT INTO `manl_geodir_custom_sort_fields` VALUES("2", "gd_place", "VARCHAR", "text", "Title", "post_title", "1", "0", "0", "1", "0", "asc");

/* INSERT TABLE DATA: manl_geodir_gd_place_detail */
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1214", "Franklin Square", "trash", "", ",117,123,", "117", "0", "/2020/02/a1.jpg", "156.57.44.101", "0", "0", "Major\'s Path, Pippy Park", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1A 4Z9", "47.608500001326", "-52.733382309342", NULL, NULL, "1", "(111) 677-4444", "info@franklinsq.com", "http://franklinsquare.com", "http://twitter.com/franklinsquare", "http://facebook.com/franklinsquare");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1216", "Please Touch Museum", "trash", "", ",117,123,", "117", "0", "/2020/02/a6-1.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.63308243092", "-52.610025879539", NULL, NULL, "1", "(222) 777-1111", "info@pleasetouchmuseum.com", "http://pleasetouchmuseum.com", "http://twitter.com/pleasetouchmuseum", "http://facebook.com/pleasetouchmuseum");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1218", "Longwood Gardens", "trash", "", ",117,", "117", "0", "/2020/02/a9-2.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.456840476388", "-52.596942024788", NULL, NULL, "1", "(111) 888-1111", "info@longwoodgardens.com", "http://longwoodgardens.com", "http://twitter.com/longwoodgardens", "http://facebook.com/longwoodgardens");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1220", "The Philadelphia Zoo", "trash", "", ",117,", "117", "0", "/2020/02/a11-3.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.521746871326", "-52.597178846059", NULL, NULL, "1", "(211) 143-1900", "info@philadelphiazoo.com", "http://philadelphiazoo.com", "http://twitter.com/philadelphiazoo", "http://facebook.com/philadelphiazoo");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1222", "National Constitution Center", "trash", "", ",117,123,", "117", "0", "/2020/02/a12.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.406321115014", "-52.697198485264", NULL, NULL, "1", "(111) 111-1111", "info@ncc.com", "http://ncc.com", "http://twitter.com/ncc", "http://facebook.com/ncc");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1224", "Sadsbury Woods Preserve", "trash", "", ",117,", "117", "0", "/2020/02/a14.jpg", "156.57.44.101", "0", "0", "Valleyview Road", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1G 1G3", "47.493941102005", "-52.757743014947", NULL, NULL, "1", "(222) 999-9999", "info@swp.com", "http://swp.com", "http://twitter.com/swp", "http://facebook.com/swp");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1226", "Museum Without Walls", "trash", "", ",117,", "117", "0", "/2020/02/a15.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.693174141944", "-52.847489296654", NULL, NULL, "1", "(222) 999-9999", "info@mwwalls.com", "http://museumwithoutwallsaudio.org/", "http://twitter.com/mwwalls", "http://facebook.com/mwwalls");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1228", "Audacious Freedom", "trash", "", ",117,", "117", "0", "/2020/02/a18.jpg", "156.57.44.101", "0", "0", "Kenmount Road, Wishingwell Park, Pippy Park", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1B 1W2", "47.555125251743", "-52.762440348748", NULL, NULL, "1", "(777) 777-7777", "info@aampmuseum.com", "http://www.aampmuseum.org/", "http://twitter.com/aampmuseum", "http://facebook.com/aampmuseum");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1230", "The Liberty Bell Center", "trash", "", ",117,123,", "117", "0", "/2020/02/a19.jpg", "156.57.44.101", "0", "0", "White Hills", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.590850780355", "-52.676386579483", NULL, NULL, "1", "(777) 666-6666", "info@nps.com", "http://www.nps.gov/inde", "http://twitter.com/nps", "http://facebook.com/nps");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1232", "Rittenhouse Square", "trash", "", ",117,", "117", "0", "/2020/02/a19-1.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.514284035953", "-52.733649901377", NULL, NULL, "1", "(777) 666-6666", "info@fairmountpark.com", "http://www.fairmountpark.org/rittenhousesquare.asp", "http://twitter.com/fairmountpark", "http://facebook.com/fairmountpark");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1234", "Loews Philadelphia Hotel", "trash", "", ",118,123,", "118", "0", "/2020/02/hotels1.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.590548864161", "-52.657478325498", NULL, NULL, "1", "(111) 111-0000", "info@loewshotels.com", "http://www.loewshotels.com/en/hotels/philadelphia-hotel/overview.aspx", "http://twitter.com/loewshotels", "http://facebook.com/loewshotels");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1236", "Embassy Suites Philadelphia", "trash", "", ",118,", "118", "0", "/2020/02/hotels5-1.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.496953560191", "-52.587017843116", NULL, NULL, "1", "(111) 111-0000", "info@embassysuites1.com", "http://embassysuites1.hilton.com/en_US/es/hotel/PHLDTES-Embassy-Suites-Philadelphia-Center-City-Pennsylvania/index.do", "http://twitter.com/embassysuites1", "http://facebook.com/embassysuites1");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1238", "Doubletree Hotel Philadelphia", "trash", "", ",118,", "118", "0", "/2020/02/hotels10-2.jpg", "156.57.44.101", "0", "0", "Salerno Place", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1K 1A4", "47.651254711431", "-52.720082547515", NULL, NULL, "1", "(111) 111-0000", "info@doubletree1.com", "http://doubletree1.hilton.com/en_US/dt/hotel/PHLBLDT-Doubletree-Hotel-Philadelphia-Pennsylvania/index.do", "http://twitter.com/doubletree1", "http://facebook.com/doubletree1");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1240", "Philadelphia Marriott Downtown", "trash", "", ",118,123,", "118", "0", "/2020/02/hotels15.jpg", "156.57.44.101", "0", "0", "Aberdeen Avenue", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1A 0H5", "47.623328190539", "-52.718028099458", NULL, NULL, "1", "(123) 111-2222", "info@marriott.com", "http://www.marriott.com/hotels/travel/phldt-philadelphia-marriott-downtown/", "http://twitter.com/marriott", "http://facebook.com/marriott");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1242", "Hilton Inn at Penn", "trash", "", ",118,120,", "118", "0", "/2020/02/hotels10-3.jpg", "156.57.44.101", "0", "0", "Gates Place, Glendale", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1N 2C4", "47.503133286778", "-52.798557745165", NULL, NULL, "1", "(888) 888-8888", "info@theinnatpenn.com", "http://www.theinnatpenn.com/", "http://twitter.com/theinnatpenn", "http://facebook.com/theinnatpenn");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1244", "Courtyard Philadelphia Downtown", "trash", "", ",118,120,", "118", "0", "/2020/02/hotels17.jpg", "156.57.44.101", "0", "0", "Dunn\'s Lane, Glendale", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1N 3J5", "47.521251191567", "-52.776339489851", NULL, NULL, "1", "(888) 888-8888", "info@theinnatpenn.com", "http://www.theinnatpenn.com/", "http://twitter.com/theinnatpenn", "http://facebook.com/theinnatpenn");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1246", "Four Seasons Philadelphia", "trash", "", ",118,120,", "118", "0", "/2020/02/hotels11-3.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.467873563621", "-52.690194568006", NULL, NULL, "1", "(143) 888-8888", "info@fourseasons.com", "http://www.fourseasons.com/philadelphia/", "http://twitter.com/fourseasons", "http://facebook.com/fourseasons");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1248", "Alexander Inn", "trash", "", ",118,", "118", "0", "/2020/02/hotels11-4.jpg", "156.57.44.101", "0", "0", "Clinch Crescent, Wishingwell Park, Pippy Park", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1B 3X9", "47.574658800945", "-52.739270241584", NULL, NULL, "1", "(143) 888-8888", "info@alexanderinn.com", "http://www.alexanderinn.com/", "http://twitter.com/alexanderinn", "http://facebook.com/alexanderinn");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1250", "Best Western Center City Hotel", "trash", "", ",118,120,", "118", "0", "/2020/02/hotels5-2.jpg", "156.57.44.101", "0", "0", "Blackhead", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.549353739915", "-52.634510821597", NULL, NULL, "1", "(243) 222-12344", "info@alexanderinn.com", "http://book.bestwestern.com/bestwestern/productInfo.do?propertyCode=39087", "http://twitter.com/bestwestern", "http://facebook.com/bestwestern");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1252", "Chestnut Hill Hotel", "trash", "", ",118,123,", "118", "0", "/2020/02/hotels7-9.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.674288658542", "-52.717443686784", NULL, NULL, "1", "(243) 222-12344", "info@chestnuthillhotel.com", "http://www.chestnuthillhotel.com/", "http://twitter.com/chestnuthillhotel", "http://facebook.com/chestnuthillhotel");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1254", "Village Whiskey", "trash", "", ",119,123,", "119", "0", "/2020/02/restaurants1.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.547282925627", "-52.576321516724", NULL, NULL, "1", "(243) 222-12344", "info@villagewhiskey.com", "http://www.villagewhiskey.com/", "http://twitter.com/villagewhiskey", "http://facebook.com/villagewhiskey");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1256", "Zavino Pizzeria and Wine Bar", "trash", "", ",119,", "119", "0", "/2020/02/restaurants4-1.jpg", "156.57.44.101", "0", "0", "Pearltown Road, Southlands", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1N 2C4", "47.503557546367", "-52.76956665317", NULL, NULL, "1", "(243) 222-12344", "info@chestnuthillhotel.com", "http://www.villagewhiskey.com/", "http://twitter.com/villagewhiskey", "http://facebook.com/villagewhiskey");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1258", "Parc", "trash", "", ",119,", "119", "0", "/2020/02/restaurants5-2.jpg", "156.57.44.101", "0", "0", "Bauline Line", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1K 1E7", "47.699345525533", "-52.799662936234", NULL, NULL, "1", "(143) 222-12344", "info@parc-restaurant.com", "http://www.parc-restaurant.com/", "http://twitter.com/parc-restaurant", "http://facebook.com/parc-restaurant");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1260", "Percy Street Barbecue", "trash", "", ",119,123,", "119", "0", "/2020/02/restaurants9-3.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.453296342686", "-52.848903195919", NULL, NULL, "1", "(143) 222-12344", "info@percystreet.com", "http://www.percystreet.com/", "http://twitter.com/percystreet", "http://facebook.com/percystreet");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1262", "The Fountain Restaurant", "trash", "", ",119,", "119", "0", "/2020/02/restaurants4-4.jpg", "156.57.44.101", "0", "0", "Blackhead", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "", "47.529496148765", "-52.643839053556", NULL, NULL, "1", "(103) 100-12344", "info@fourseasons.com", "http://www.fourseasons.com/philadelphia/dining", "http://twitter.com/fourseasons", "http://facebook.com/fourseasons");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1264", "Lacroix at The Rittenhouse", "trash", "", ",119,", "119", "0", "/2020/02/restaurants11-3.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.616417723525", "-52.798231962431", NULL, NULL, "1", "(113) 121-12344", "info@rittenhousehotel.com", "http://www.rittenhousehotel.com/lacroix.cfm", "http://twitter.com/rittenhousehotel", "http://facebook.com/rittenhousehotel");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1266", "The Rittenhouse", "trash", "", ",119,120,", "119", "0", "/2020/02/restaurants12.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.454200488419", "-52.833251109667", NULL, NULL, "1", "(113) 121-12344", "info@zamarestaurant.com", "http://www.zamarestaurant.com/", "http://twitter.com/zamarestaurant", "http://facebook.com/zamarestaurant");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1268", "Sampan", "trash", "", ",119,120,", "119", "0", "/2020/02/restaurants16.jpg", "156.57.44.101", "0", "0", "St. John\'s", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 1W2", "47.601112103981", "-52.649563570453", NULL, NULL, "1", "(000) 111-2222", "info@sampanphilly.com", "http://www.sampanphilly.com/", "http://twitter.com/sampanphilly", "http://facebook.com/sampanphilly");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1270", "Morimoto", "trash", "", ",119,120,123,", "119", "0", "/2020/02/restaurants17-1.jpg", "156.57.44.101", "0", "0", "Allandale Road, Pippy Park, Pippy Park", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1B 4E8", "47.586366570528", "-52.755428111267", NULL, NULL, "1", "(000) 111-2222", "info@morimotorestaurant.com", "http://www.morimotorestaurant.com/", "http://twitter.com/morimotorestaurant", "http://facebook.com/morimotorestaurant");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1272", "Buddakan", "trash", "", ",137,138,", "137", "0", "/2020/02/restaurants19-2.jpg", "156.57.44.101", "0", "0", "MountainView Drive", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1S 1G6", "47.450902474241", "-52.780068601535", NULL, NULL, "1", "(000) 111-2222", "info@buddakan.com", "http://www.buddakan.com/", "http://twitter.com/buddakan", "http://facebook.com/buddakan");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1274", "The Rooms", "publish", "", ",116,", "116", "0", NULL, "156.57.44.101", "0", "0", "9 Bonaventure Avenue", NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", "A1C 5P9", "47.56601548307889", "-52.71146249797312", "ROADMAP", "16", "0", "", "", "https://therooms.ca", "", "");
INSERT INTO `manl_geodir_gd_place_detail` VALUES("1276", "Auto Draft", "auto-draft", NULL, NULL, NULL, "0", NULL, "156.57.44.101", "0", "0", NULL, NULL, "St. John\'s", "Newfoundland and Labrador", "Canada", NULL, NULL, NULL, NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL);

/* INSERT TABLE DATA: manl_geodir_tabs_layout */
INSERT INTO `manl_geodir_tabs_layout` VALUES("1", "gd_place", "1", "post", "", "meta", "0", "Profile", "fas fa-home", "post_content", "");
INSERT INTO `manl_geodir_tabs_layout` VALUES("2", "gd_place", "2", "post", "", "standard", "0", "Photos", "fas fa-image", "post_images", "[gd_post_images type=\"gallery\" ajax_load=\"1\" slideshow=\"1\" show_title=\"1\" animation=\"slide\" controlnav=\"1\" link_to=\"lightbox\"]");
INSERT INTO `manl_geodir_tabs_layout` VALUES("3", "gd_place", "3", "post", "", "standard", "0", "Map", "fas fa-globe-americas", "post_map", "[gd_map width=\"100%\" height=\"325px\" maptype=\"ROADMAP\" zoom=\"0\" map_type=\"post\" map_directions=\"1\"]");

/* INSERT TABLE DATA: manl_login_log */
INSERT INTO `manl_login_log` VALUES("1", "156.57.44.101", "Login success", "2019-11-29 02:49:26", "success", "new");
INSERT INTO `manl_login_log` VALUES("2", "209.128.7.181", "Login success", "2020-02-19 15:49:34", "success", "new");

/* INSERT TABLE DATA: manl_options */
INSERT INTO `manl_options` VALUES("1", "siteurl", "http://labs.mdcis.com/manl", "yes");
INSERT INTO `manl_options` VALUES("2", "home", "http://labs.mdcis.com/manl", "yes");
INSERT INTO `manl_options` VALUES("3", "blogname", "Museum Association of Newfoundland and Labrador", "yes");
INSERT INTO `manl_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `manl_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `manl_options` VALUES("6", "admin_email", "mark@colemanis.ca", "yes");
INSERT INTO `manl_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `manl_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `manl_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `manl_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `manl_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `manl_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `manl_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `manl_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `manl_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `manl_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `manl_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `manl_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `manl_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `manl_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `manl_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `manl_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `manl_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `manl_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `manl_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `manl_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `manl_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `manl_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `manl_options` VALUES("29", "rewrite_rules", "a:412:{s:11:\"business/?$\";s:28:\"index.php?post_type=business\";s:41:\"business/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=business&feed=$matches[1]\";s:36:\"business/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=business&feed=$matches[1]\";s:28:\"business/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=business&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"dashboard/?$\";s:26:\"index.php?action=dashboard\";s:8:\"login/?$\";s:22:\"index.php?action=login\";s:9:\"logout/?$\";s:23:\"index.php?action=logout\";s:11:\"register/?$\";s:25:\"index.php?action=register\";s:15:\"lostpassword/?$\";s:29:\"index.php?action=lostpassword\";s:12:\"resetpass/?$\";s:26:\"index.php?action=resetpass\";s:16:\"confirmaction/?$\";s:30:\"index.php?action=confirmaction\";s:14:\"testimonial/?$\";s:31:\"index.php?post_type=testimonial\";s:44:\"testimonial/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:39:\"testimonial/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:31:\"testimonial/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=testimonial&paged=$matches[1]\";s:10:\"gallery/?$\";s:27:\"index.php?post_type=gallery\";s:40:\"gallery/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:35:\"gallery/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:27:\"gallery/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=gallery&paged=$matches[1]\";s:13:\"exhibition/?$\";s:30:\"index.php?post_type=exhibition\";s:43:\"exhibition/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=exhibition&feed=$matches[1]\";s:38:\"exhibition/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=exhibition&feed=$matches[1]\";s:30:\"exhibition/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=exhibition&paged=$matches[1]\";s:17:\"exhibition_reg/?$\";s:34:\"index.php?post_type=exhibition_reg\";s:47:\"exhibition_reg/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=exhibition_reg&feed=$matches[1]\";s:42:\"exhibition_reg/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=exhibition_reg&feed=$matches[1]\";s:34:\"exhibition_reg/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=exhibition_reg&paged=$matches[1]\";s:8:\"event/?$\";s:25:\"index.php?post_type=event\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:20:\"event_registrants/?$\";s:37:\"index.php?post_type=event_registrants\";s:50:\"event_registrants/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=event_registrants&feed=$matches[1]\";s:45:\"event_registrants/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=event_registrants&feed=$matches[1]\";s:37:\"event_registrants/page/([0-9]{1,})/?$\";s:55:\"index.php?post_type=event_registrants&paged=$matches[1]\";s:7:\"team/?$\";s:24:\"index.php?post_type=team\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=team&paged=$matches[1]\";s:10:\"artwork/?$\";s:27:\"index.php?post_type=artwork\";s:40:\"artwork/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=artwork&feed=$matches[1]\";s:35:\"artwork/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=artwork&feed=$matches[1]\";s:27:\"artwork/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=artwork&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:58:\"business_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?business_category=$matches[1]&feed=$matches[2]\";s:53:\"business_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?business_category=$matches[1]&feed=$matches[2]\";s:34:\"business_category/([^/]+)/embed/?$\";s:50:\"index.php?business_category=$matches[1]&embed=true\";s:46:\"business_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?business_category=$matches[1]&paged=$matches[2]\";s:28:\"business_category/([^/]+)/?$\";s:39:\"index.php?business_category=$matches[1]\";s:57:\"membership_level/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?membership_level=$matches[1]&feed=$matches[2]\";s:52:\"membership_level/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?membership_level=$matches[1]&feed=$matches[2]\";s:33:\"membership_level/([^/]+)/embed/?$\";s:49:\"index.php?membership_level=$matches[1]&embed=true\";s:45:\"membership_level/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?membership_level=$matches[1]&paged=$matches[2]\";s:27:\"membership_level/([^/]+)/?$\";s:38:\"index.php?membership_level=$matches[1]\";s:57:\"private_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?private_category=$matches[1]&feed=$matches[2]\";s:52:\"private_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?private_category=$matches[1]&feed=$matches[2]\";s:33:\"private_category/([^/]+)/embed/?$\";s:49:\"index.php?private_category=$matches[1]&embed=true\";s:45:\"private_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?private_category=$matches[1]&paged=$matches[2]\";s:27:\"private_category/([^/]+)/?$\";s:38:\"index.php?private_category=$matches[1]\";s:34:\"business/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"business/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"business/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"business/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"business/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"business/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"business/(.+?)/embed/?$\";s:41:\"index.php?business=$matches[1]&embed=true\";s:27:\"business/(.+?)/trackback/?$\";s:35:\"index.php?business=$matches[1]&tb=1\";s:47:\"business/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?business=$matches[1]&feed=$matches[2]\";s:42:\"business/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?business=$matches[1]&feed=$matches[2]\";s:35:\"business/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?business=$matches[1]&paged=$matches[2]\";s:42:\"business/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?business=$matches[1]&cpage=$matches[2]\";s:31:\"business/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?business=$matches[1]&page=$matches[2]\";s:45:\"swpm_transactions/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"swpm_transactions/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"swpm_transactions/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"swpm_transactions/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"swpm_transactions/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"swpm_transactions/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"swpm_transactions/([^/]+)/embed/?$\";s:50:\"index.php?swpm_transactions=$matches[1]&embed=true\";s:38:\"swpm_transactions/([^/]+)/trackback/?$\";s:44:\"index.php?swpm_transactions=$matches[1]&tb=1\";s:46:\"swpm_transactions/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?swpm_transactions=$matches[1]&paged=$matches[2]\";s:53:\"swpm_transactions/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?swpm_transactions=$matches[1]&cpage=$matches[2]\";s:42:\"swpm_transactions/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?swpm_transactions=$matches[1]&page=$matches[2]\";s:34:\"swpm_transactions/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"swpm_transactions/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"swpm_transactions/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"swpm_transactions/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"swpm_transactions/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"swpm_transactions/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial-category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial-category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial-category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial-category=$matches[1]&embed=true\";s:49:\"testimonial-category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial-category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial-category/([^/]+)/?$\";s:42:\"index.php?testimonial-category=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:52:\"testimonial/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:47:\"testimonial/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"gallery-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery-category=$matches[1]&feed=$matches[2]\";s:52:\"gallery-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery-category=$matches[1]&feed=$matches[2]\";s:33:\"gallery-category/([^/]+)/embed/?$\";s:49:\"index.php?gallery-category=$matches[1]&embed=true\";s:45:\"gallery-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?gallery-category=$matches[1]&paged=$matches[2]\";s:27:\"gallery-category/([^/]+)/?$\";s:38:\"index.php?gallery-category=$matches[1]\";s:35:\"gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"gallery/([^/]+)/embed/?$\";s:40:\"index.php?gallery=$matches[1]&embed=true\";s:28:\"gallery/([^/]+)/trackback/?$\";s:34:\"index.php?gallery=$matches[1]&tb=1\";s:48:\"gallery/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:43:\"gallery/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:36:\"gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&paged=$matches[2]\";s:43:\"gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&cpage=$matches[2]\";s:32:\"gallery/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?gallery=$matches[1]&page=$matches[2]\";s:24:\"gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"venue/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?venue=$matches[1]&feed=$matches[2]\";s:41:\"venue/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?venue=$matches[1]&feed=$matches[2]\";s:22:\"venue/([^/]+)/embed/?$\";s:38:\"index.php?venue=$matches[1]&embed=true\";s:34:\"venue/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?venue=$matches[1]&paged=$matches[2]\";s:16:\"venue/([^/]+)/?$\";s:27:\"index.php?venue=$matches[1]\";s:60:\"exhibition-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?exhibition-category=$matches[1]&feed=$matches[2]\";s:55:\"exhibition-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?exhibition-category=$matches[1]&feed=$matches[2]\";s:36:\"exhibition-category/([^/]+)/embed/?$\";s:52:\"index.php?exhibition-category=$matches[1]&embed=true\";s:48:\"exhibition-category/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?exhibition-category=$matches[1]&paged=$matches[2]\";s:30:\"exhibition-category/([^/]+)/?$\";s:41:\"index.php?exhibition-category=$matches[1]\";s:55:\"exhibition-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?exhibition-tag=$matches[1]&feed=$matches[2]\";s:50:\"exhibition-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?exhibition-tag=$matches[1]&feed=$matches[2]\";s:31:\"exhibition-tag/([^/]+)/embed/?$\";s:47:\"index.php?exhibition-tag=$matches[1]&embed=true\";s:43:\"exhibition-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?exhibition-tag=$matches[1]&paged=$matches[2]\";s:25:\"exhibition-tag/([^/]+)/?$\";s:36:\"index.php?exhibition-tag=$matches[1]\";s:38:\"exhibition/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"exhibition/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"exhibition/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"exhibition/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"exhibition/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"exhibition/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"exhibition/([^/]+)/embed/?$\";s:43:\"index.php?exhibition=$matches[1]&embed=true\";s:31:\"exhibition/([^/]+)/trackback/?$\";s:37:\"index.php?exhibition=$matches[1]&tb=1\";s:51:\"exhibition/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?exhibition=$matches[1]&feed=$matches[2]\";s:46:\"exhibition/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?exhibition=$matches[1]&feed=$matches[2]\";s:39:\"exhibition/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?exhibition=$matches[1]&paged=$matches[2]\";s:46:\"exhibition/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?exhibition=$matches[1]&cpage=$matches[2]\";s:35:\"exhibition/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?exhibition=$matches[1]&page=$matches[2]\";s:27:\"exhibition/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"exhibition/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"exhibition/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"exhibition/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"exhibition/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"exhibition/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:62:\"registrant-exhibition/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?registrant-exhibition=$matches[1]&feed=$matches[2]\";s:57:\"registrant-exhibition/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?registrant-exhibition=$matches[1]&feed=$matches[2]\";s:38:\"registrant-exhibition/([^/]+)/embed/?$\";s:54:\"index.php?registrant-exhibition=$matches[1]&embed=true\";s:50:\"registrant-exhibition/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?registrant-exhibition=$matches[1]&paged=$matches[2]\";s:32:\"registrant-exhibition/([^/]+)/?$\";s:43:\"index.php?registrant-exhibition=$matches[1]\";s:42:\"exhibition_reg/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"exhibition_reg/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"exhibition_reg/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"exhibition_reg/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"exhibition_reg/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"exhibition_reg/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"exhibition_reg/([^/]+)/embed/?$\";s:47:\"index.php?exhibition_reg=$matches[1]&embed=true\";s:35:\"exhibition_reg/([^/]+)/trackback/?$\";s:41:\"index.php?exhibition_reg=$matches[1]&tb=1\";s:55:\"exhibition_reg/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?exhibition_reg=$matches[1]&feed=$matches[2]\";s:50:\"exhibition_reg/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?exhibition_reg=$matches[1]&feed=$matches[2]\";s:43:\"exhibition_reg/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?exhibition_reg=$matches[1]&paged=$matches[2]\";s:50:\"exhibition_reg/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?exhibition_reg=$matches[1]&cpage=$matches[2]\";s:39:\"exhibition_reg/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?exhibition_reg=$matches[1]&page=$matches[2]\";s:31:\"exhibition_reg/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"exhibition_reg/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"exhibition_reg/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"exhibition_reg/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"exhibition_reg/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"exhibition_reg/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"event-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event-category=$matches[1]&feed=$matches[2]\";s:50:\"event-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event-category=$matches[1]&feed=$matches[2]\";s:31:\"event-category/([^/]+)/embed/?$\";s:47:\"index.php?event-category=$matches[1]&embed=true\";s:43:\"event-category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?event-category=$matches[1]&paged=$matches[2]\";s:25:\"event-category/([^/]+)/?$\";s:36:\"index.php?event-category=$matches[1]\";s:50:\"event-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?event-tag=$matches[1]&feed=$matches[2]\";s:45:\"event-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?event-tag=$matches[1]&feed=$matches[2]\";s:26:\"event-tag/([^/]+)/embed/?$\";s:42:\"index.php?event-tag=$matches[1]&embed=true\";s:38:\"event-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?event-tag=$matches[1]&paged=$matches[2]\";s:20:\"event-tag/([^/]+)/?$\";s:31:\"index.php?event-tag=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"event_registrants/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"event_registrants/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"event_registrants/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"event_registrants/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"event_registrants/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"event_registrants/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"event_registrants/([^/]+)/embed/?$\";s:50:\"index.php?event_registrants=$matches[1]&embed=true\";s:38:\"event_registrants/([^/]+)/trackback/?$\";s:44:\"index.php?event_registrants=$matches[1]&tb=1\";s:58:\"event_registrants/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?event_registrants=$matches[1]&feed=$matches[2]\";s:53:\"event_registrants/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?event_registrants=$matches[1]&feed=$matches[2]\";s:46:\"event_registrants/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?event_registrants=$matches[1]&paged=$matches[2]\";s:53:\"event_registrants/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?event_registrants=$matches[1]&cpage=$matches[2]\";s:42:\"event_registrants/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?event_registrants=$matches[1]&page=$matches[2]\";s:34:\"event_registrants/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"event_registrants/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"event_registrants/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"event_registrants/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"event_registrants/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"event_registrants/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"team-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team-category=$matches[1]&feed=$matches[2]\";s:49:\"team-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team-category=$matches[1]&feed=$matches[2]\";s:30:\"team-category/([^/]+)/embed/?$\";s:46:\"index.php?team-category=$matches[1]&embed=true\";s:42:\"team-category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?team-category=$matches[1]&paged=$matches[2]\";s:24:\"team-category/([^/]+)/?$\";s:35:\"index.php?team-category=$matches[1]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"artwork-tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?artwork-tags=$matches[1]&feed=$matches[2]\";s:48:\"artwork-tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?artwork-tags=$matches[1]&feed=$matches[2]\";s:29:\"artwork-tags/([^/]+)/embed/?$\";s:45:\"index.php?artwork-tags=$matches[1]&embed=true\";s:41:\"artwork-tags/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?artwork-tags=$matches[1]&paged=$matches[2]\";s:23:\"artwork-tags/([^/]+)/?$\";s:34:\"index.php?artwork-tags=$matches[1]\";s:56:\"artwork-artists/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?artwork-artists=$matches[1]&feed=$matches[2]\";s:51:\"artwork-artists/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?artwork-artists=$matches[1]&feed=$matches[2]\";s:32:\"artwork-artists/([^/]+)/embed/?$\";s:48:\"index.php?artwork-artists=$matches[1]&embed=true\";s:44:\"artwork-artists/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?artwork-artists=$matches[1]&paged=$matches[2]\";s:26:\"artwork-artists/([^/]+)/?$\";s:37:\"index.php?artwork-artists=$matches[1]\";s:35:\"artwork/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"artwork/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"artwork/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"artwork/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"artwork/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"artwork/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"artwork/([^/]+)/embed/?$\";s:40:\"index.php?artwork=$matches[1]&embed=true\";s:28:\"artwork/([^/]+)/trackback/?$\";s:34:\"index.php?artwork=$matches[1]&tb=1\";s:48:\"artwork/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?artwork=$matches[1]&feed=$matches[2]\";s:43:\"artwork/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?artwork=$matches[1]&feed=$matches[2]\";s:36:\"artwork/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?artwork=$matches[1]&paged=$matches[2]\";s:43:\"artwork/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?artwork=$matches[1]&cpage=$matches[2]\";s:32:\"artwork/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?artwork=$matches[1]&page=$matches[2]\";s:24:\"artwork/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"artwork/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"artwork/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"artwork/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"artwork/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"artwork/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"wp-file-download/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?wpfd-category=$matches[1]&feed=$matches[2]\";s:52:\"wp-file-download/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?wpfd-category=$matches[1]&feed=$matches[2]\";s:33:\"wp-file-download/([^/]+)/embed/?$\";s:46:\"index.php?wpfd-category=$matches[1]&embed=true\";s:45:\"wp-file-download/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?wpfd-category=$matches[1]&paged=$matches[2]\";s:27:\"wp-file-download/([^/]+)/?$\";s:35:\"index.php?wpfd-category=$matches[1]\";s:37:\"wpfd_file/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"wpfd_file/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"wpfd_file/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wpfd_file/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wpfd_file/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"wpfd_file/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"wpfd_file/([^/]+)/embed/?$\";s:42:\"index.php?wpfd_file=$matches[1]&embed=true\";s:30:\"wpfd_file/([^/]+)/trackback/?$\";s:36:\"index.php?wpfd_file=$matches[1]&tb=1\";s:38:\"wpfd_file/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?wpfd_file=$matches[1]&paged=$matches[2]\";s:45:\"wpfd_file/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?wpfd_file=$matches[1]&cpage=$matches[2]\";s:34:\"wpfd_file/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?wpfd_file=$matches[1]&page=$matches[2]\";s:26:\"wpfd_file/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"wpfd_file/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"wpfd_file/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"wpfd_file/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"wpfd_file/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"wpfd_file/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `manl_options` VALUES("7907", "widget_wpfd_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7909", "external_updates-wp-file-download", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1611021346;s:14:\"checkedVersion\";s:6:\"4.7.14\";s:6:\"update\";O:8:\"stdClass\":8:{s:2:\"id\";i:0;s:4:\"slug\";s:16:\"wp-file-download\";s:7:\"version\";s:5:\"4.9.5\";s:8:\"homepage\";s:62:\"https://www.joomunited.com/wordpress-products/wp-file-download\";s:12:\"download_url\";s:121:\"https://www.joomunited.com/index.php?option=com_juupdater&task=download.download&extension=wp-file-download&version=4.9.5\";s:14:\"upgrade_notice\";s:29:\"Upgrade to the latest version\";s:8:\"filename\";s:37:\"wp-file-download/wp-file-download.php\";s:5:\"icons\";O:8:\"stdClass\":1:{s:7:\"default\";s:86:\"https://www.joomunited.com/juupdater_files/wordpress_banners/wp-file-download-icon.png\";}}}", "no");
INSERT INTO `manl_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `manl_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `manl_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `manl_options` VALUES("33", "active_plugins", "a:22:{i:0;s:26:\"ag-custom-admin/plugin.php\";i:1;s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";i:2;s:37:\"breadcrumb-navxt/breadcrumb-navxt.php\";i:3;s:65:\"chamber-dashboard-business-directory/cdash-business-directory.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:44:\"custom-twitter-feeds/custom-twitter-feed.php\";i:6;s:37:\"disable-comments/disable-comments.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:21:\"megamenu/megamenu.php\";i:9;s:31:\"pojo-sidebars/pojo-sidebars.php\";i:10;s:29:\"remove_menus/remove_menus.php\";i:11;s:23:\"revslider/revslider.php\";i:12;s:74:\"simple-membership-after-login-redirection/swpm-after-login-redirection.php\";i:13;s:42:\"simple-membership/simple-wp-membership.php\";i:14;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:15;s:39:\"so-widgets-bundle/so-widgets-bundle.php\";i:16;s:33:\"theme-my-login/theme-my-login.php\";i:17;s:24:\"vestige-core/vestige.php\";i:18;s:23:\"wordfence/wordfence.php\";i:19;s:37:\"wp-file-download/wp-file-download.php\";i:20;s:35:\"wp-font-awesome/wp-font-awesome.php\";i:21;s:23:\"zigcookie/zigcookie.php\";}", "yes");
INSERT INTO `manl_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `manl_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `manl_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `manl_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `manl_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `manl_options` VALUES("39", "recently_edited", "a:3:{i:0;s:81:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/themes/vestige/style.css\";i:1;s:87:\"/home/mdcgroup/public_html/dev.mdcis.com/manl/wp-content/themes/vestige-child/style.css\";i:2;s:0:\"\";}", "no");
INSERT INTO `manl_options` VALUES("40", "template", "vestige", "yes");
INSERT INTO `manl_options` VALUES("41", "stylesheet", "vestige", "yes");
INSERT INTO `manl_options` VALUES("14373", "finished_updating_comment_type", "1", "yes");
INSERT INTO `manl_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `manl_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `manl_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `manl_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `manl_options` VALUES("48", "db_version", "49752", "yes");
INSERT INTO `manl_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `manl_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `manl_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `manl_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `manl_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `manl_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `manl_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `manl_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `manl_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `manl_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `manl_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `manl_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `manl_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `manl_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `manl_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `manl_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `manl_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `manl_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `manl_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `manl_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `manl_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `manl_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `manl_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `manl_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `manl_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `manl_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `manl_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `manl_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `manl_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("78", "widget_categories", "a:2:{i:3;a:4:{s:5:\"title\";s:15:\"Post Categories\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("79", "widget_text", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("81", "uninstall_plugins", "a:2:{s:37:\"wp-file-download/wp-file-download.php\";s:14:\"wpfd_uninstall\";s:65:\"chamber-dashboard-business-directory/cdash-business-directory.php\";s:27:\"cdash_delete_plugin_options\";}", "no");
INSERT INTO `manl_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `manl_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `manl_options` VALUES("84", "page_on_front", "12", "yes");
INSERT INTO `manl_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `manl_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `manl_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `manl_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `manl_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `manl_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `manl_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `manl_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `manl_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `manl_options` VALUES("94", "manl_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:126:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:25:\"manage_lana_download_logs\";b:1;s:20:\"wpfd_create_category\";b:1;s:18:\"wpfd_edit_category\";b:1;s:22:\"wpfd_edit_own_category\";b:1;s:20:\"wpfd_delete_category\";b:1;s:16:\"wpfd_manage_file\";b:1;s:18:\"bcn_manage_options\";b:1;s:35:\"manage_custom_twitter_feeds_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:20:\"wpfd_create_category\";b:1;s:18:\"wpfd_edit_category\";b:1;s:22:\"wpfd_edit_own_category\";b:1;s:20:\"wpfd_delete_category\";b:1;s:16:\"wpfd_manage_file\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "yes");
INSERT INTO `manl_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `manl_options` VALUES("96", "widget_search", "a:2:{i:3;a:1:{s:5:\"title\";s:12:\"Search Posts\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("97", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("98", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("99", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("100", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("101", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:6:\"name-1\";}s:12:\"post-sidebar\";a:0:{}s:12:\"page-sidebar\";a:1:{i:0;s:10:\"nav_menu-3\";}s:13:\"event-sidebar\";a:0:{}s:15:\"product-sidebar\";a:0:{}s:14:\"footer-sidebar\";a:3:{i:0;s:10:\"nav_menu-1\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-2\";}s:16:\"pojo-sidebar-102\";a:0:{}s:16:\"pojo-sidebar-103\";a:2:{i:0;s:23:\"vestige_selected_post-2\";i:1;s:26:\"vestige_next_exhibitions-1\";}s:16:\"pojo-sidebar-104\";a:3:{i:0;s:8:\"search-3\";i:1;s:11:\"tag_cloud-1\";i:2;s:12:\"categories-3\";}s:9:\"mega-menu\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `manl_options` VALUES("102", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("103", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("104", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("105", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("106", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("107", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("108", "widget_tag_cloud", "a:2:{i:1;a:3:{s:5:\"title\";s:9:\"Post Tags\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("109", "widget_nav_menu", "a:3:{i:1;a:2:{s:5:\"title\";s:10:\"Navigation\";s:8:\"nav_menu\";i:85;}i:3;a:1:{s:8:\"nav_menu\";i:146;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("110", "widget_custom_html", "a:3:{i:2;a:2:{s:5:\"title\";s:10:\"Contact US\";s:7:\"content\";s:465:\"<ul style=\'list-style=none;\'>\r\n<li style=\"margin: 2px 0\">[wpfa5s icon=\"building\"] 200 Military Road</li>\r\n<li style=\"margin: 2px 0\">St. John\'s, Newfoundland</li>\r\n<li style=\"margin: 2px 0\">[wpfa5s icon=\"phone\"] (709) 722-9034</li>\r\n<li style=\"margin: 2px 0\">[wpfa5s icon=\"fax\"] (709) 722-9035</li>\r\n<li style=\"margin: 2px 0\">[wpfa5s icon=\"envelope\"] info@museumsnl.ca</li>\r\n	<li style=\"margin: 2px 0\">[wpfa5s icon=\"clock\"] Mon - Fri 8:30AM - 4:30PM </li>\r\n\r\n</ul>\r\n\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:12:\"<p>\r\n	\r\n</p>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("111", "cron", "a:18:{i:1611023991;a:2:{s:25:\"swpm_account_status_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"swpm_delete_pending_account_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1611024202;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1611024472;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1611024813;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1611027787;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1611027802;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1611059345;a:2:{s:37:\"check_plugin_updates-wp-file-download\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:23:\"wpfd_remove_junks_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"wpfd_clean_junks\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1611060472;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1611060484;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1611060536;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1611112464;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1611168000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"5ea57c3bd21f25156cb06257ee2fc11f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1611168000;}}}}i:1611317403;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1611409723;a:1:{s:23:\"ctf_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1611427200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"351ebedd3873237aaf9a6262a6adf2ce\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1611427200;}}}}i:1611590400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1611686400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"3a389ab5c3a4d525b9b0a4a4ecd37a2c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1611686400;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `manl_options` VALUES("7442", "geodirectory_admin_notices", "a:3:{i:0;s:13:\"theme_support\";i:1;s:4:\"beta\";i:2;s:14:\"template_files\";}", "yes");
INSERT INTO `manl_options` VALUES("8183", "geodirectory_version", "2.0.0.81", "yes");
INSERT INTO `manl_options` VALUES("8184", "geodirectory_db_version", "2.0.0.81", "yes");
INSERT INTO `manl_options` VALUES("7409", "widget_gd_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7410", "widget_gd_best_of", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7411", "widget_gd_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7412", "widget_gd_category_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7413", "widget_gd_dashboard", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7414", "widget_gd_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("112", "theme_mods_twentynineteen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1582126691;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"name-1\";i:1;s:6:\"text-2\";i:2;s:10:\"nav_menu-1\";i:3;s:6:\"text-3\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";i:4;s:6:\"meta-2\";i:5;s:6:\"text-1\";}s:16:\"pojo-sidebar-102\";a:2:{i:0;s:25:\"vestige_upcoming_events-1\";i:1;s:23:\"vestige_selected_post-1\";}s:16:\"pojo-sidebar-103\";a:2:{i:0;s:23:\"vestige_selected_post-2\";i:1;s:26:\"vestige_next_exhibitions-1\";}s:16:\"pojo-sidebar-104\";a:3:{i:0;s:8:\"search-3\";i:1;s:11:\"tag_cloud-1\";i:2;s:12:\"categories-3\";}s:9:\"mega-menu\";a:0:{}}}s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:87;}}", "yes");
INSERT INTO `manl_options` VALUES("149", "current_theme", "Vestige", "yes");
INSERT INTO `manl_options` VALUES("150", "theme_mods_vestige-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:87;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1582337076;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:6:\"name-1\";}s:16:\"pojo-sidebar-102\";a:0:{}s:16:\"pojo-sidebar-103\";a:2:{i:0;s:23:\"vestige_selected_post-2\";i:1;s:26:\"vestige_next_exhibitions-1\";}s:16:\"pojo-sidebar-104\";a:3:{i:0;s:8:\"search-3\";i:1;s:11:\"tag_cloud-1\";i:2;s:12:\"categories-3\";}s:9:\"mega-menu\";a:0:{}s:12:\"post-sidebar\";a:0:{}s:12:\"page-sidebar\";a:1:{i:0;s:25:\"vestige_upcoming_events-1\";}s:13:\"event-sidebar\";a:0:{}s:15:\"product-sidebar\";a:0:{}s:14:\"footer-sidebar\";a:3:{i:0;s:6:\"text-2\";i:1;s:10:\"nav_menu-1\";i:2;s:13:\"custom_html-2\";}}}}", "yes");
INSERT INTO `manl_options` VALUES("151", "theme_switched", "", "yes");
INSERT INTO `manl_options` VALUES("152", "widget_upcoming_events", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("153", "widget_selected_post", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("154", "widget_name", "a:2:{i:1;a:3:{s:5:\"title\";s:18:\"Artwork Categories\";s:4:\"type\";s:7:\"artwork\";s:4:\"show\";i:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("155", "widget_next_exhibitions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("4455", "_transient_wc_attribute_taxonomies", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("6164", "lana_downloads_manager_endpoint", "downloads", "yes");
INSERT INTO `manl_options` VALUES("6161", "widget_lana_download", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("158", "envato_market_version", "2.0.0", "yes");
INSERT INTO `manl_options` VALUES("159", "redux_version_upgraded_from", "3.6.15", "yes");
INSERT INTO `manl_options` VALUES("160", "widget_vestige_upcoming_events", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("161", "widget_vestige_selected_post", "a:2:{i:2;a:3:{s:5:\"title\";s:11:\"Recent News\";s:4:\"type\";s:4:\"post\";s:6:\"number\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("162", "widget_vestige_next_exhibitions", "a:2:{i:1;a:2:{s:5:\"title\";s:16:\"Next Exhibitions\";s:6:\"number\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("163", "envato_market_installed_version", "2.0.0", "yes");
INSERT INTO `manl_options` VALUES("164", "envato_market_state", "install", "yes");
INSERT INTO `manl_options` VALUES("9211", "_transient_health-check-site-status-result", "{\"good\":\"10\",\"recommended\":\"9\",\"critical\":\"1\"}", "yes");
INSERT INTO `manl_options` VALUES("14392", "cdash_directory_options", "a:30:{s:14:\"bus_phone_type\";s:4:\"Main\";s:14:\"bus_email_type\";s:4:\"Main\";s:19:\"cdash_default_thumb\";s:0:\"\";s:14:\"sv_description\";s:1:\"1\";s:7:\"sv_name\";s:1:\"1\";s:10:\"sv_address\";s:1:\"1\";s:6:\"sv_map\";s:1:\"1\";s:6:\"sv_url\";s:1:\"1\";s:8:\"sv_phone\";s:1:\"1\";s:8:\"sv_email\";s:1:\"1\";s:7:\"sv_logo\";s:1:\"1\";s:8:\"sv_thumb\";s:1:\"1\";s:11:\"sv_category\";s:1:\"1\";s:8:\"tax_name\";s:1:\"1\";s:11:\"tax_address\";s:1:\"1\";s:8:\"tax_logo\";s:1:\"1\";s:9:\"tax_thumb\";s:1:\"1\";s:12:\"tax_category\";s:1:\"1\";s:16:\"tax_orderby_name\";s:1:\"1\";s:10:\"sm_display\";s:5:\"icons\";s:12:\"sm_icon_size\";s:4:\"32px\";s:8:\"currency\";s:3:\"CAD\";s:15:\"currency_symbol\";s:1:\"$\";s:17:\"currency_position\";s:6:\"before\";s:23:\"search_results_per_page\";s:2:\"25\";s:21:\"business_listings_url\";s:0:\"\";s:26:\"business_listings_url_text\";s:25:\"Return to Museum Listings\";s:15:\"google_maps_api\";s:0:\"\";s:22:\"google_maps_server_api\";s:0:\"\";s:10:\"bus_custom\";a:1:{i:1;a:2:{s:4:\"name\";s:0:\"\";s:4:\"type\";s:0:\"\";}}}", "yes");
INSERT INTO `manl_options` VALUES("7892", "_transient_timeout_megamenu_css", "4737225727", "no");
INSERT INTO `manl_options` VALUES("7893", "_transient_megamenu_css", "/** Sunday 8th March 2020 00:02:07 UTC (core) **/\n/** THIS FILE IS AUTOMATICALLY GENERATED - DO NOT MAKE MANUAL EDITS! **/\n/** Custom CSS should be added to Mega Menu > Menu Themes > Custom Styling **/\n\n.mega-menu-last-modified-1583625727 { content: \'Sunday 8th March 2020 00:02:07 UTC\'; }\n\n#mega-menu-wrap-primary-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-row, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-column, #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link {\n  transition: none;\n  border-radius: 0;\n  box-shadow: none;\n  background: none;\n  border: 0;\n  bottom: auto;\n  box-sizing: border-box;\n  clip: auto;\n  color: #666;\n  display: block;\n  float: none;\n  font-family: inherit;\n  font-size: 14px;\n  height: auto;\n  left: auto;\n  line-height: 1.7;\n  list-style-type: none;\n  margin: 0;\n  min-height: auto;\n  max-height: none;\n  opacity: 1;\n  outline: none;\n  overflow: visible;\n  padding: 0;\n  position: relative;\n  pointer-events: auto;\n  right: auto;\n  text-align: left;\n  text-decoration: none;\n  text-indent: 0;\n  text-transform: none;\n  transform: none;\n  top: auto;\n  vertical-align: baseline;\n  visibility: inherit;\n  width: auto;\n  word-wrap: break-word;\n  white-space: normal;\n}\n#mega-menu-wrap-primary-menu:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu ul.mega-sub-menu:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-row:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-column:before, #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link:before, #mega-menu-wrap-primary-menu:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu ul.mega-sub-menu:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-row:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-column:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link:after {\n  display: none;\n}\n#mega-menu-wrap-primary-menu {\n  border-radius: 0;\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu {\n    background: #222;\n  }\n}\n#mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-menu-toggle:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-toggle-block:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-toggle-block a:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-toggle-block .mega-search input[type=text]:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-toggle-block button.mega-toggle-animated:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation #mega-menu-primary-menu a:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation #mega-menu-primary-menu input:focus, #mega-menu-wrap-primary-menu.mega-keyboard-navigation #mega-menu-primary-menu li.mega-menu-item a.mega-menu-link:focus {\n  outline: 3px solid #109cde;\n  outline-offset: -3px;\n}\n#mega-menu-wrap-primary-menu.mega-keyboard-navigation .mega-toggle-block button.mega-toggle-animated:focus {\n  outline-offset: 2px;\n}\n#mega-menu-wrap-primary-menu.mega-keyboard-navigation > li.mega-menu-item > a.mega-menu-link:focus {\n  background: #333;\n  color: #fff;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: #fff;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu.mega-keyboard-navigation > li.mega-menu-item > a.mega-menu-link:focus {\n    color: #fff;\n    background: #333;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu {\n  visibility: visible;\n  text-align: left;\n  padding: 0px 0px 0px 0px;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link {\n  cursor: pointer;\n  display: inline;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link .mega-description-group {\n  vertical-align: middle;\n  display: inline-block;\n  transition: none;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link .mega-description-group .mega-menu-title, #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link .mega-description-group .mega-menu-description {\n  transition: none;\n  line-height: 1.5;\n  display: block;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link .mega-description-group .mega-menu-description {\n  font-style: italic;\n  font-size: 0.8em;\n  text-transform: none;\n  font-weight: normal;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: flex;\n  align-items: center;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link:before {\n  flex: 0 0 auto;\n  align-self: flex-start;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-tabbed.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: block;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-icon-top > a.mega-menu-link {\n  display: table-cell;\n  vertical-align: middle;\n  line-height: initial;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-icon-top > a.mega-menu-link:before {\n  display: block;\n  margin: 0 0 6px 0;\n  text-align: center;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-icon-top > a.mega-menu-link > span.mega-title-below {\n  display: inline-block;\n  transition: none;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-icon-top > a.mega-menu-link {\n    display: block;\n    line-height: 40px;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-icon-top > a.mega-menu-link:before {\n    display: inline-block;\n    margin: 0 6px 0 0;\n    text-align: left;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-icon-right > a.mega-menu-link:before {\n  float: right;\n  margin: 0 0 0 6px;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-animating > ul.mega-sub-menu {\n  pointer-events: none;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-disable-link > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu li.mega-disable-link > a.mega-menu-link {\n  cursor: inherit;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-disable-link > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > li.mega-menu-item-has-children.mega-disable-link > a.mega-menu-link {\n  cursor: pointer;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu p {\n  margin-bottom: 10px;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu input, #mega-menu-wrap-primary-menu #mega-menu-primary-menu img {\n  max-width: 100%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item > ul.mega-sub-menu {\n  display: block;\n  visibility: hidden;\n  opacity: 1;\n  pointer-events: auto;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item > ul.mega-sub-menu {\n    display: none;\n    visibility: visible;\n    opacity: 1;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu.mega-menu-item.mega-toggle-on ul.mega-sub-menu {\n    display: block;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu.mega-menu-item.mega-toggle-on li.mega-hide-sub-menu-on-mobile > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-hide-sub-menu-on-mobile > ul.mega-sub-menu {\n    display: none;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade\"] li.mega-menu-item > ul.mega-sub-menu {\n    opacity: 0;\n    transition: opacity 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    opacity: 1;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-megamenu > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-flyout ul.mega-sub-menu {\n    opacity: 0;\n    transform: translate(0, 10px);\n    transition: opacity 200ms ease-in, transform 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    opacity: 1;\n    transform: translate(0, 0);\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-megamenu > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-flyout ul.mega-sub-menu {\n    transform: translate(0, 10px);\n    transition: transform 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    transform: translate(0, 0);\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-collapse-children > ul.mega-sub-menu {\n  display: none;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-collapse-children.mega-toggle-on > ul.mega-sub-menu {\n  display: block;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu {\n  visibility: visible;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu ul.mega-sub-menu {\n  visibility: inherit;\n  opacity: 1;\n  display: block;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-1-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 100%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-2-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 50%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-3-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 33.33333%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-4-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 25%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item a[class^=\'dashicons\']:before {\n  font-family: dashicons;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item a.mega-menu-link:before {\n  display: inline-block;\n  font: inherit;\n  font-family: dashicons;\n  position: static;\n  margin: 0 6px 0 0px;\n  vertical-align: top;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  color: inherit;\n  background: transparent;\n  height: auto;\n  width: auto;\n  top: auto;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-hide-text a.mega-menu-link:before {\n  margin: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item.mega-hide-text li.mega-menu-item a.mega-menu-link:before {\n  margin: 0 6px 0 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-align-bottom-left.mega-toggle-on > a.mega-menu-link {\n  border-radius: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-align-bottom-right > ul.mega-sub-menu {\n  right: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-align-bottom-right.mega-toggle-on > a.mega-menu-link {\n  border-radius: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-menu-item {\n  position: static;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item {\n  margin: 0 0px 0 0;\n  display: inline-block;\n  height: auto;\n  vertical-align: middle;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-item-align-right {\n  float: right;\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-item-align-right {\n    margin: 0 0 0 0px;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-item-align-float-left {\n    float: left;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item > a.mega-menu-link:hover {\n    background: #333;\n    color: #fff;\n    font-weight: normal;\n    text-decoration: none;\n    border-color: #fff;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-toggle-on > a.mega-menu-link {\n  background: #333;\n  color: #fff;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: #fff;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-toggle-on > a.mega-menu-link {\n    color: #fff;\n    background: #333;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link {\n  background: #333;\n  color: #fff;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: #fff;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link {\n    color: #fff;\n    background: #333;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item > a.mega-menu-link {\n  line-height: 40px;\n  height: 40px;\n  padding: 0px 10px 0px 10px;\n  vertical-align: baseline;\n  width: auto;\n  display: block;\n  color: #fff;\n  text-transform: none;\n  text-decoration: none;\n  text-align: left;\n  text-decoration: none;\n  background: rgba(0, 0, 0, 0);\n  border: 0;\n  border-radius: 0;\n  font-family: inherit;\n  font-size: 14px;\n  font-weight: normal;\n  outline: none;\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-multi-line > a.mega-menu-link {\n    line-height: inherit;\n    display: table-cell;\n    vertical-align: middle;\n  }\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-multi-line > a.mega-menu-link br {\n    display: none;\n  }\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item {\n    display: list-item;\n    margin: 0;\n    clear: both;\n    border: 0;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item.mega-item-align-right {\n    float: none;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item > a.mega-menu-link {\n    border-radius: 0;\n    border: 0;\n    margin: 0;\n    line-height: 40px;\n    height: 40px;\n    padding: 0 10px;\n    background: transparent;\n    text-align: left;\n    color: #fff;\n    font-size: 14px;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row {\n  width: 100%;\n  float: left;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row .mega-menu-column {\n  float: left;\n  min-height: 1px;\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-1 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-2 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-2 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-3 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-3 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-3 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-4 {\n    width: 25%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-4 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-4 {\n    width: 75%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-4 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-5 {\n    width: 20%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-5 {\n    width: 40%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-5 {\n    width: 60%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-5 {\n    width: 80%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-5 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-6 {\n    width: 16.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-6 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-6 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-6 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-6 {\n    width: 83.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-6 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-7 {\n    width: 14.28571%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-7 {\n    width: 28.57143%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-7 {\n    width: 42.85714%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-7 {\n    width: 57.14286%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-7 {\n    width: 71.42857%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-7 {\n    width: 85.71429%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-7 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-8 {\n    width: 12.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-8 {\n    width: 25%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-8 {\n    width: 37.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-8 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-8 {\n    width: 62.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-8 {\n    width: 75%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-8 {\n    width: 87.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-8 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-9 {\n    width: 11.11111%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-9 {\n    width: 22.22222%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-9 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-9 {\n    width: 44.44444%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-9 {\n    width: 55.55556%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-9 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-9 {\n    width: 77.77778%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-9 {\n    width: 88.88889%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-9 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-10 {\n    width: 10%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-10 {\n    width: 20%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-10 {\n    width: 30%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-10 {\n    width: 40%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-10 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-10 {\n    width: 60%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-10 {\n    width: 70%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-10 {\n    width: 80%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-10 {\n    width: 90%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-10 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-11 {\n    width: 9.09091%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-11 {\n    width: 18.18182%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-11 {\n    width: 27.27273%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-11 {\n    width: 36.36364%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-11 {\n    width: 45.45455%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-11 {\n    width: 54.54545%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-11 {\n    width: 63.63636%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-11 {\n    width: 72.72727%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-11 {\n    width: 81.81818%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-11 {\n    width: 90.90909%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-11-of-11 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-12 {\n    width: 8.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-12 {\n    width: 16.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-12 {\n    width: 25%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-12 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-12 {\n    width: 41.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-12 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-12 {\n    width: 58.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-12 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-12 {\n    width: 75%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-12 {\n    width: 83.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-11-of-12 {\n    width: 91.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-12-of-12 {\n    width: 100%;\n  }\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-column {\n    width: 100%;\n    clear: both;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row .mega-menu-column > ul.mega-sub-menu > li.mega-menu-item {\n  padding: 15px 15px 15px 15px;\n  width: 100%;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu {\n  z-index: 999;\n  border-radius: 0;\n  background: #f1f1f1;\n  border: 0;\n  padding: 0px 0px 0px 0px;\n  position: absolute;\n  width: 100%;\n  max-width: none;\n  left: 0;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu {\n    float: left;\n    position: static;\n    width: 100%;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-1 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-2 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-2 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-3 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-3 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-3 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-4 {\n    width: 25%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-4 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-4 {\n    width: 75%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-4 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-5 {\n    width: 20%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-5 {\n    width: 40%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-5 {\n    width: 60%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-5 {\n    width: 80%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-5 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-6 {\n    width: 16.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-6 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-6 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-6 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-6 {\n    width: 83.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-6 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-7 {\n    width: 14.28571%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-7 {\n    width: 28.57143%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-7 {\n    width: 42.85714%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-7 {\n    width: 57.14286%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-7 {\n    width: 71.42857%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-7 {\n    width: 85.71429%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-7 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-8 {\n    width: 12.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-8 {\n    width: 25%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-8 {\n    width: 37.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-8 {\n    width: 50%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-8 {\n    width: 62.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-8 {\n    width: 75%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-8 {\n    width: 87.5%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-8 {\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-9 {\n    width: 11.11111%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-9 {\n    width: 22.22222%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-9 {\n    width: 33.33333%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-9 {\n    width: 44.44444%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-9 {\n    width: 55.55556%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-9 {\n    width: 66.66667%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-9 {\n    width: 77.77778%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-9 {\n    width: 88.88889%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-9-of-9 {\n    width: 100%;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu .mega-description-group .mega-menu-description {\n  margin: 5px 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item ul.mega-sub-menu {\n  clear: both;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n  margin-left: 10px;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu ul.mega-sub-menu ul.mega-sub-menu {\n  margin-left: 10px;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item {\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  display: block;\n  float: left;\n  clear: none;\n  padding: 15px 15px 15px 15px;\n  vertical-align: top;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item.mega-menu-clear, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-menu-clear {\n  clear: left;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title {\n  color: #555;\n  font-family: inherit;\n  font-size: 16px;\n  text-transform: uppercase;\n  text-decoration: none;\n  font-weight: bold;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 0px 0px 5px 0px;\n  vertical-align: top;\n  display: block;\n  visibility: inherit;\n  border: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title:hover {\n  border-color: rgba(0, 0, 0, 0);\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link {\n  /* Mega Menu > Menu Themes > Mega Menus > Second Level Menu Items */\n  color: #555;\n  font-family: inherit;\n  font-size: 14px;\n  text-transform: none;\n  text-decoration: none;\n  font-weight: 300;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 5px 0px 5px 0px;\n  vertical-align: top;\n  display: block;\n  border: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover {\n  border-color: rgba(0, 0, 0, 0);\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus {\n  /* Mega Menu > Menu Themes > Mega Menus > Second Level Menu Items (Hover) */\n  color: #555;\n  font-weight: normal;\n  text-decoration: none;\n  background: rgba(0, 0, 0, 0);\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link {\n  /* Mega Menu > Menu Themes > Mega Menus > Third Level Menu Items */\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  text-transform: none;\n  text-decoration: none;\n  font-weight: normal;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 5px 0px 0px 0px;\n  vertical-align: top;\n  display: block;\n  border: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover {\n  border-color: rgba(0, 0, 0, 0);\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: flex;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:focus, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:focus {\n  /* Mega Menu > Menu Themes > Mega Menus > Third Level Menu Items (Hover) */\n  color: #666;\n  font-weight: normal;\n  text-decoration: none;\n  background: rgba(0, 0, 0, 0);\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu {\n    border: 0;\n    padding: 10px;\n    border-radius: 0;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item {\n    width: 100%;\n    clear: both;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link {\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  text-transform: none;\n  text-decoration: none;\n  font-weight: normal;\n  margin: 0;\n  border: 0;\n  padding: 5px 0px 0px 0px;\n  vertical-align: top;\n  display: block;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus {\n  color: #666;\n  font-weight: normal;\n  text-decoration: none;\n  background: rgba(0, 0, 0, 0);\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu {\n  z-index: 999;\n  position: absolute;\n  width: 250px;\n  max-width: none;\n  padding: 0px 0px 0px 0px;\n  border: 0;\n  background: #f1f1f1;\n  border-radius: 0;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu {\n    float: left;\n    position: static;\n    width: 100%;\n    padding: 0;\n    border: 0;\n    border-radius: 0;\n  }\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item {\n    clear: both;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link {\n  display: block;\n  background: #f1f1f1;\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  font-weight: normal;\n  padding: 0px 10px 0px 10px;\n  line-height: 35px;\n  text-decoration: none;\n  text-transform: none;\n  vertical-align: baseline;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:first-child > a.mega-menu-link {\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:first-child > a.mega-menu-link {\n    border-top-left-radius: 0;\n    border-top-right-radius: 0;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:last-child > a.mega-menu-link {\n  border-bottom-right-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:last-child > a.mega-menu-link {\n    border-bottom-right-radius: 0;\n    border-bottom-left-radius: 0;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:hover, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:focus {\n  background: #ddd;\n  font-weight: normal;\n  text-decoration: none;\n  color: #666;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n  position: absolute;\n  left: 100%;\n  top: 0;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n    position: static;\n    left: 0;\n    width: 100%;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu a.mega-menu-link {\n    padding-left: 20px;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after {\n  content: \'\\f140\';\n  font-family: dashicons;\n  font-weight: normal;\n  display: inline-block;\n  margin: 0 0 0 6px;\n  vertical-align: top;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  transform: rotate(0);\n  color: inherit;\n  position: relative;\n  background: transparent;\n  height: auto;\n  width: auto;\n  right: auto;\n  line-height: inherit;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n  display: inline;\n  height: auto;\n  width: auto;\n  background: transparent;\n  position: relative;\n  pointer-events: auto;\n  left: auto;\n  min-width: auto;\n  line-height: inherit;\n  color: inherit;\n  font-size: inherit;\n  padding: 0;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n  float: right;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-collapse-children.mega-toggle-on > a.mega-menu-link > span.mega-indicator:after {\n  content: \'\\f142\';\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n    float: right;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-toggle-on > a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f142\';\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-hide-sub-menu-on-mobile > a.mega-menu-link > span.mega-indicator {\n    display: none;\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-megamenu:not(.mega-menu-tabbed) li.mega-menu-item-has-children:not(.mega-collapse-children) > a.mega-menu-link > span.mega-indicator, #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-hide-arrow > a.mega-menu-link > span.mega-indicator {\n  display: none;\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout li.mega-menu-item a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f139\';\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link {\n    text-align: right;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link > span.mega-indicator {\n    float: left;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f141\';\n    margin: 0 6px 0 0;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link:before {\n    float: right;\n    margin: 0 0 0 6px;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout.mega-align-bottom-right ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n    left: -100%;\n    top: 0;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-right.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator, #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-right.mega-menu-flyout li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n    float: right;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-right.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-right.mega-menu-flyout li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f139\';\n    margin: 0;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-left.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator, #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-left.mega-menu-flyout li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n    float: left;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-left.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after, #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-vertical li.mega-align-bottom-left.mega-menu-flyout li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f141\';\n    margin: 0;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-accordion > li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n    float: right;\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu.mega-menu-accordion li.mega-menu-item-has-children.mega-toggle-on > a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f142\';\n  }\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-tabbed > ul.mega-sub-menu > li.mega-menu-item.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after {\n    content: \'\\f139\';\n  }\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu li[class^=\'mega-lang-item\'] > a.mega-menu-link > img {\n  display: inline;\n}\n#mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link > img.wpml-ls-flag, #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link > img.iclflag {\n  display: inline;\n  margin-right: 8px;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-hide-on-mobile, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-hide-on-mobile, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-hide-on-mobile {\n    display: none;\n  }\n}\n@media only screen and (min-width: 601px) {\n  #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-hide-on-desktop, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-hide-on-desktop, #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-hide-on-desktop {\n    display: none;\n  }\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu:after {\n    content: \"\";\n    display: table;\n    clear: both;\n  }\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle {\n  display: none;\n  z-index: 1;\n  cursor: pointer;\n  background: #222;\n  border-radius: 2px 2px 2px 2px;\n  line-height: 40px;\n  height: 40px;\n  text-align: left;\n  -webkit-touch-callout: none;\n  -webkit-user-select: none;\n  -khtml-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  -webkit-tap-highlight-color: transparent;\n  outline: none;\n  white-space: nowrap;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle img {\n  max-width: 100%;\n  padding: 0;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu .mega-menu-toggle {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: -webkit-flex;\n    display: flex;\n  }\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-left, #mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-center, #mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-right {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: -webkit-flex;\n  display: flex;\n  -ms-flex-preferred-size: 33.33%;\n  -webkit-flex-basis: 33.33%;\n  flex-basis: 33.33%;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-left {\n  -webkit-box-flex: 1;\n  -ms-flex: 1;\n  -webkit-flex: 1;\n  flex: 1;\n  -webkit-box-pack: start;\n  -ms-flex-pack: start;\n  -webkit-justify-content: flex-start;\n  justify-content: flex-start;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-left .mega-toggle-block {\n  margin-left: 6px;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-center {\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  -webkit-justify-content: center;\n  justify-content: center;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-center .mega-toggle-block {\n  margin-left: 3px;\n  margin-right: 3px;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-right {\n  -webkit-box-flex: 1;\n  -ms-flex: 1;\n  -webkit-flex: 1;\n  flex: 1;\n  -webkit-box-pack: end;\n  -ms-flex-pack: end;\n  -webkit-justify-content: flex-end;\n  justify-content: flex-end;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-blocks-right .mega-toggle-block {\n  margin-right: 6px;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: -webkit-flex;\n  display: flex;\n  height: 100%;\n  outline: 0;\n  -webkit-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center;\n  -ms-flex-negative: 0;\n  -webkit-flex-shrink: 0;\n  flex-shrink: 0;\n}\n@media only screen and (max-width: 600px) {\n  #mega-menu-wrap-primary-menu .mega-menu-toggle + #mega-menu-primary-menu {\n    background: #222;\n    padding: 0px 0px 0px 0px;\n    display: none;\n  }\n  #mega-menu-wrap-primary-menu .mega-menu-toggle.mega-menu-open + #mega-menu-primary-menu {\n    display: block;\n  }\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle {\n  /** Push menu onto new line **/\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block-1 {\n  cursor: pointer;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block-1:after {\n  content: \'\\f333\';\n  font-family: \'dashicons\';\n  font-size: 24px;\n  color: #ddd;\n  margin: 0 0 0 5px;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block-1 .mega-toggle-label {\n  color: #ddd;\n  font-size: 14px;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block-1 .mega-toggle-label .mega-toggle-label-open {\n  display: none;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle .mega-toggle-block-1 .mega-toggle-label .mega-toggle-label-closed {\n  display: inline;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle.mega-menu-open .mega-toggle-block-1:after {\n  content: \'\\f153\';\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle.mega-menu-open .mega-toggle-block-1 .mega-toggle-label-open {\n  display: inline;\n}\n#mega-menu-wrap-primary-menu .mega-menu-toggle.mega-menu-open .mega-toggle-block-1 .mega-toggle-label-closed {\n  display: none;\n}\n#mega-menu-wrap-primary-menu {\n  clear: both;\n}\n", "no");
INSERT INTO `manl_options` VALUES("4450", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"KLs55GHJ7Lu0HdCLbqhvlcOWpDTFzMlP\";}", "yes");
INSERT INTO `manl_options` VALUES("19936", "_site_transient_timeout_theme_roots", "1611023140", "no");
INSERT INTO `manl_options` VALUES("19937", "_site_transient_theme_roots", "a:5:{s:8:\"__MACOSX\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:13:\"vestige-child\";s:7:\"/themes\";s:11:\"vestige.off\";s:7:\"/themes\";s:7:\"vestige\";s:7:\"/themes\";}", "no");
INSERT INTO `manl_options` VALUES("7397", "wp_country_database_version", "1.0.2", "no");
INSERT INTO `manl_options` VALUES("7398", "geodir_settings", "a:79:{s:10:\"taxonomies\";a:2:{s:13:\"gd_place_tags\";a:3:{s:11:\"object_type\";s:8:\"gd_place\";s:12:\"listing_slug\";s:11:\"places/tags\";s:4:\"args\";a:5:{s:6:\"public\";b:1;s:12:\"hierarchical\";b:0;s:7:\"rewrite\";a:3:{s:4:\"slug\";s:11:\"places/tags\";s:10:\"with_front\";b:0;s:12:\"hierarchical\";b:1;}s:9:\"query_var\";b:1;s:6:\"labels\";a:12:{s:4:\"name\";s:10:\"Place Tags\";s:13:\"singular_name\";s:9:\"Place Tag\";s:12:\"search_items\";s:17:\"Search Place Tags\";s:13:\"popular_items\";s:18:\"Popular Place Tags\";s:9:\"all_items\";s:14:\"All Place Tags\";s:9:\"edit_item\";s:14:\"Edit Place Tag\";s:11:\"update_item\";s:16:\"Update Place Tag\";s:12:\"add_new_item\";s:17:\"Add New Place Tag\";s:13:\"new_item_name\";s:18:\"New Place Tag Name\";s:19:\"add_or_remove_items\";s:24:\"Add or remove Place tags\";s:21:\"choose_from_most_used\";s:36:\"Choose from the most used Place tags\";s:26:\"separate_items_with_commas\";s:31:\"Separate Place tags with commas\";}}}s:16:\"gd_placecategory\";a:3:{s:11:\"object_type\";s:8:\"gd_place\";s:12:\"listing_slug\";s:6:\"places\";s:4:\"args\";a:5:{s:6:\"public\";b:1;s:12:\"hierarchical\";b:1;s:7:\"rewrite\";a:3:{s:4:\"slug\";s:6:\"places\";s:10:\"with_front\";b:0;s:12:\"hierarchical\";b:1;}s:9:\"query_var\";b:1;s:6:\"labels\";a:10:{s:4:\"name\";s:16:\"Place Categories\";s:13:\"singular_name\";s:14:\"Place Category\";s:12:\"search_items\";s:23:\"Search Place Categories\";s:13:\"popular_items\";s:24:\"Popular Place Categories\";s:9:\"all_items\";s:20:\"All Place Categories\";s:9:\"edit_item\";s:19:\"Edit Place Category\";s:11:\"update_item\";s:21:\"Update Place Category\";s:12:\"add_new_item\";s:22:\"Add New Place Category\";s:13:\"new_item_name\";s:18:\"New Place Category\";s:19:\"add_or_remove_items\";s:30:\"Add or remove Place categories\";}}}}s:10:\"post_types\";a:1:{s:8:\"gd_place\";a:25:{s:6:\"labels\";a:10:{s:4:\"name\";s:7:\"museums\";s:13:\"singular_name\";s:6:\"museum\";s:7:\"add_new\";s:7:\"Add New\";s:12:\"add_new_item\";s:13:\"Add New Place\";s:9:\"edit_item\";s:10:\"Edit Place\";s:8:\"new_item\";s:9:\"New Place\";s:9:\"view_item\";s:10:\"View Place\";s:12:\"search_items\";s:13:\"Search Places\";s:9:\"not_found\";s:14:\"No Place Found\";s:18:\"not_found_in_trash\";s:23:\"No Place Found In Trash\";}s:11:\"description\";s:16:\"Place post type.\";s:10:\"can_export\";b:1;s:15:\"capability_type\";s:4:\"post\";s:11:\"has_archive\";s:7:\"museums\";s:12:\"hierarchical\";b:0;s:12:\"map_meta_cap\";b:1;s:6:\"public\";b:1;s:9:\"query_var\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"rewrite\";a:4:{s:4:\"slug\";s:7:\"museums\";s:10:\"with_front\";b:0;s:12:\"hierarchical\";b:1;s:5:\"feeds\";b:1;}s:8:\"supports\";a:8:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:9:\"thumbnail\";i:4;s:7:\"excerpt\";i:5;s:13:\"custom-fields\";i:6;s:8:\"comments\";i:7;s:9:\"revisions\";}s:10:\"taxonomies\";a:2:{i:0;s:16:\"gd_placecategory\";i:1;s:13:\"gd_place_tags\";}s:13:\"listing_order\";i:1;s:15:\"disable_reviews\";i:0;s:17:\"disable_favorites\";i:0;s:20:\"disable_frontend_add\";i:0;s:20:\"author_posts_private\";i:0;s:24:\"author_favorites_private\";i:0;s:3:\"seo\";a:3:{s:5:\"title\";s:0:\"\";s:10:\"meta_title\";s:0:\"\";s:16:\"meta_description\";s:0:\"\";}s:9:\"menu_icon\";s:22:\"dashicons-location-alt\";s:13:\"default_image\";s:0:\"\";s:12:\"page_details\";i:0;s:12:\"page_archive\";i:0;s:17:\"page_archive_item\";i:0;}}s:19:\"admin_blocked_roles\";a:1:{i:0;s:10:\"subscriber\";}s:16:\"user_trash_posts\";s:1:\"1\";s:14:\"default_status\";s:7:\"pending\";s:15:\"post_logged_out\";s:1:\"0\";s:12:\"post_preview\";s:1:\"1\";s:19:\"upload_max_filesize\";s:1:\"2\";s:16:\"noindex_archives\";s:1:\"0\";s:19:\"google_maps_api_key\";s:0:\"\";s:22:\"google_geocode_api_key\";s:0:\"\";s:8:\"maps_api\";s:4:\"auto\";s:12:\"map_language\";s:2:\"en\";s:23:\"map_default_marker_icon\";s:42:\"plugins/geodirectory/assets/images/pin.png\";s:9:\"map_cache\";s:1:\"0\";s:14:\"usage_tracking\";b:0;s:21:\"default_location_city\";s:10:\"St. John\'s\";s:23:\"default_location_region\";s:25:\"Newfoundland and Labrador\";s:24:\"default_location_country\";s:6:\"Canada\";s:25:\"default_location_latitude\";s:17:\"47.56718242474943\";s:26:\"default_location_longitude\";s:18:\"-52.71096253381985\";s:19:\"search_default_text\";s:0:\"\";s:24:\"search_default_near_text\";s:0:\"\";s:26:\"search_default_button_text\";s:0:\"\";s:13:\"search_radius\";s:1:\"7\";s:20:\"search_distance_long\";s:5:\"miles\";s:21:\"search_distance_short\";s:4:\"feet\";s:20:\"search_near_addition\";s:0:\"\";s:17:\"search_word_limit\";s:1:\"0\";s:12:\"enable_hints\";i:0;s:17:\"enable_404_rescue\";i:1;s:17:\"admin_enable_beta\";i:0;s:27:\"email_bcc_user_pending_post\";i:0;s:27:\"email_bcc_user_publish_post\";i:0;s:30:\"email_bcc_owner_comment_submit\";i:0;s:22:\"email_bcc_send_enquiry\";i:0;s:24:\"email_admin_pending_post\";i:1;s:21:\"email_admin_post_edit\";i:0;s:28:\"email_admin_moderate_comment\";i:0;s:23:\"email_user_pending_post\";i:1;s:23:\"email_user_publish_post\";i:1;s:26:\"email_owner_comment_submit\";i:0;s:28:\"email_owner_comment_approved\";i:1;s:29:\"email_author_comment_approved\";i:1;s:21:\"archive_page_template\";s:0:\"\";s:21:\"listing_default_image\";i:0;s:24:\"details_disable_featured\";s:1:\"1\";s:21:\"details_page_template\";s:0:\"\";s:12:\"rating_color\";s:7:\"#ff9900\";s:16:\"rating_color_off\";s:7:\"#afafaf\";s:11:\"rating_type\";s:12:\"font-awesome\";s:11:\"rating_icon\";s:11:\"fas fa-star\";s:14:\"rating_icon_fw\";s:1:\"1\";s:13:\"rating_text_1\";s:0:\"\";s:13:\"rating_text_2\";s:0:\"\";s:13:\"rating_text_3\";s:0:\"\";s:13:\"rating_text_4\";s:0:\"\";s:13:\"rating_text_5\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:16:\"email_base_color\";s:7:\"#557da2\";s:22:\"email_background_color\";s:7:\"#f5f5f5\";s:27:\"email_body_background_color\";s:7:\"#fdfdfd\";s:16:\"email_text_color\";s:7:\"#505050\";s:29:\"email_header_background_color\";s:7:\"#555555\";s:23:\"email_header_text_color\";s:7:\"#ffffff\";s:29:\"email_footer_background_color\";s:7:\"#666666\";s:23:\"email_footer_text_color\";s:7:\"#dddddd\";s:16:\"rest_api_enabled\";s:3:\"yes\";s:8:\"page_add\";i:1199;s:11:\"page_search\";i:1200;s:21:\"page_terms_conditions\";i:1201;s:13:\"page_location\";i:1202;s:12:\"page_archive\";i:1203;s:17:\"page_archive_item\";i:1204;s:12:\"page_details\";i:1205;s:13:\"gd_term_icons\";a:7:{i:116;s:61:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/02/pin.png\";i:139;s:80:\"http://labs.mdcis.com/manl/wp-content/plugins/geodirectory/assets/images/pin.png\";i:140;s:80:\"http://labs.mdcis.com/manl/wp-content/plugins/geodirectory/assets/images/pin.png\";i:141;s:80:\"http://labs.mdcis.com/manl/wp-content/plugins/geodirectory/assets/images/pin.png\";i:121;s:66:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/02/Festival.png\";i:137;s:80:\"http://labs.mdcis.com/manl/wp-content/plugins/geodirectory/assets/images/pin.png\";i:138;s:80:\"http://labs.mdcis.com/manl/wp-content/plugins/geodirectory/assets/images/pin.png\";}s:25:\"default_location_timezone\";s:0:\"\";s:24:\"gd_place_dummy_data_type\";s:15:\"standard_places\";s:22:\"admin_disable_advanced\";i:0;}", "yes");
INSERT INTO `manl_options` VALUES("7399", "vestige_saved_exhibitions", "", "yes");
INSERT INTO `manl_options` VALUES("7400", "vestige_future_events_saved", "", "yes");
INSERT INTO `manl_options` VALUES("7401", "vestige_past_events_saved", "", "yes");
INSERT INTO `manl_options` VALUES("7481", "gd_placecategory_children", "a:2:{i:137;a:2:{i:0;i:138;i:1;i:139;}i:140;a:1:{i:0;i:141;}}", "yes");
INSERT INTO `manl_options` VALUES("7403", "gd_placecategory_installed", "1", "yes");
INSERT INTO `manl_options` VALUES("7415", "widget_gd_post_badge", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7416", "widget_gd_post_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7417", "widget_gd_post_images", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7418", "widget_gd_post_title", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7419", "widget_gd_post_rating", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7420", "widget_gd_post_fav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7421", "widget_gd_post_directions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7422", "widget_gd_post_content", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7423", "widget_gd_post_address", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7424", "widget_gd_output_location", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7425", "widget_gd_author_actions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7426", "widget_gd_listings", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7427", "widget_gd_map", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7428", "widget_gd_recently_viewed", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7429", "widget_gd_single_tabs", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7430", "widget_gd_notifications", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7431", "widget_gd_add_listing", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7432", "widget_gd_dynamic_content", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7433", "widget_gd_loop", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7434", "widget_gd_loop_paging", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7435", "widget_gd_loop_actions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7436", "widget_gd_archive_item_section", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7437", "widget_gd_single_taxonomies", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7438", "widget_gd_single_next_prev", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7439", "widget_gd_single_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7440", "widget_gd_post_distance", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7441", "widget_gd_map_pinpoint", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("7281", "agca_role_allbutadmin", "", "yes");
INSERT INTO `manl_options` VALUES("2296", "_tml_previous_version", "7.1.1", "no");
INSERT INTO `manl_options` VALUES("144", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("2400", "venue54_image_term_id", "http://labs.mdcis.com/manl/wp-content/uploads/2019/09/248.jpg", "yes");
INSERT INTO `manl_options` VALUES("2401", "venue54_term_banner", "http://labs.mdcis.com/manl/wp-content/uploads/2019/09/248.jpg", "yes");
INSERT INTO `manl_options` VALUES("2402", "category_54", "a:1:{s:12:\"VenueAddress\";s:73:\"564 Main Street, Old Perlican, Newfoundland and Labrador, Canada, A0A 3G0\";}", "yes");
INSERT INTO `manl_options` VALUES("156", "revslider-valid", "1", "yes");
INSERT INTO `manl_options` VALUES("168", "imic_options", "a:184:{s:8:\"last_tab\";s:0:\"\";s:18:\"enable_maintenance\";s:1:\"0\";s:16:\"enable_backtotop\";s:1:\"1\";s:17:\"space-before-head\";s:0:\"\";s:17:\"space-before-body\";s:0:\"\";s:17:\"switch-responsive\";s:1:\"1\";s:17:\"switch-zoom-pinch\";s:1:\"0\";s:11:\"site_layout\";s:5:\"boxed\";s:26:\"upload-repeatable-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"full-screen-bg-image\";a:9:{s:3:\"url\";s:78:\"http://labs.mdcis.com/manl/wp-content/uploads/2019/08/manl-site-background.png\";s:2:\"id\";s:3:\"918\";s:6:\"height\";s:4:\"2100\";s:5:\"width\";s:4:\"2399\";s:9:\"thumbnail\";s:86:\"http://labs.mdcis.com/manl/wp-content/uploads/2019/08/manl-site-background-150x150.png\";s:5:\"title\";s:20:\"manl-site-background\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"site_width\";s:4:\"1080\";s:18:\"content_background\";a:7:{s:16:\"background-color\";s:7:\"#ffffff\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:15:\"content_padding\";a:3:{s:11:\"padding-top\";s:4:\"50px\";s:14:\"padding-bottom\";s:4:\"50px\";s:5:\"units\";s:2:\"px\";}s:18:\"content_min_height\";s:3:\"400\";s:18:\"content_wide_width\";s:1:\"0\";s:13:\"header_layout\";s:13:\"header-style2\";s:23:\"header_background_alpha\";a:3:{s:5:\"color\";s:7:\"#708f41\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:18:\"rgba(112,143,65,1)\";}s:17:\"header_background\";a:6:{s:17:\"background-repeat\";s:9:\"no-repeat\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:7:\"inherit\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:75:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/new-site-header-2.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"1982\";s:6:\"height\";s:3:\"170\";s:5:\"width\";s:4:\"1400\";s:9:\"thumbnail\";s:83:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/new-site-header-2-150x150.jpg\";}}s:17:\"full_width_header\";s:1:\"0\";s:16:\"header_text_btn1\";s:0:\"\";s:15:\"header_url_btn1\";s:0:\"\";s:17:\"header_style_btn1\";s:0:\"\";s:16:\"header_text_btn2\";s:0:\"\";s:15:\"header_url_btn2\";s:0:\"\";s:17:\"header_style_btn2\";s:0:\"\";s:16:\"header_text_btn3\";s:0:\"\";s:15:\"header_url_btn3\";s:0:\"\";s:17:\"header_style_btn3\";s:0:\"\";s:19:\"enable-header-stick\";s:1:\"1\";s:20:\"header-stick-tablets\";s:1:\"1\";s:20:\"header-stick-mobiles\";s:1:\"1\";s:30:\"sticky_header_background_alpha\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:24:\"sticky_header_background\";a:6:{s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:17:\"sticky_link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:20:\"sticky_link_color_h3\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:13:\"enable_topbar\";s:1:\"1\";s:11:\"topbar_left\";s:0:\"\";s:19:\"header_social_links\";a:23:{s:11:\"fa-facebook\";s:0:\"\";s:10:\"fa-twitter\";s:30:\"https://twitter.com/manltweets\";s:12:\"fa-pinterest\";s:0:\"\";s:14:\"fa-google-plus\";s:0:\"\";s:10:\"fa-youtube\";s:0:\"\";s:12:\"fa-instagram\";s:0:\"\";s:15:\"fa-vimeo-square\";s:0:\"\";s:6:\"fa-rss\";s:0:\"\";s:11:\"fa-dribbble\";s:0:\"\";s:10:\"fa-dropbox\";s:0:\"\";s:12:\"fa-bitbucket\";s:0:\"\";s:9:\"fa-flickr\";s:34:\"https://www.flickr.com/photos/manl\";s:13:\"fa-foursquare\";s:0:\"\";s:9:\"fa-github\";s:0:\"\";s:9:\"fa-gittip\";s:0:\"\";s:11:\"fa-linkedin\";s:0:\"\";s:12:\"fa-pagelines\";s:0:\"\";s:8:\"fa-skype\";s:0:\"\";s:11:\"fa-envelope\";s:0:\"\";s:9:\"fa-tumblr\";s:0:\"\";s:14:\"fa-tripadvisor\";s:0:\"\";s:5:\"fa-vk\";s:0:\"\";s:7:\"fa-yelp\";s:0:\"\";}s:12:\"header_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"inner_header_height\";s:0:\"\";s:15:\"show_page_title\";s:1:\"0\";s:20:\"show_page_title_typo\";a:13:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h1_logo_background\";a:1:{s:16:\"background-color\";s:0:\"\";}s:11:\"logo_upload\";a:9:{s:3:\"url\";s:67:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/site-logo.png\";s:2:\"id\";s:4:\"1981\";s:6:\"height\";s:3:\"124\";s:5:\"width\";s:3:\"124\";s:9:\"thumbnail\";s:67:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/site-logo.png\";s:5:\"title\";s:9:\"site-logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:18:\"retina_logo_upload\";a:9:{s:3:\"url\";s:67:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/site-logo.png\";s:2:\"id\";s:4:\"1981\";s:6:\"height\";s:3:\"124\";s:5:\"width\";s:3:\"124\";s:9:\"thumbnail\";s:67:\"http://labs.mdcis.com/manl/wp-content/uploads/2020/10/site-logo.png\";s:5:\"title\";s:9:\"site-logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:17:\"retina_logo_width\";s:3:\"113\";s:18:\"retina_logo_height\";s:2:\"50\";s:12:\"logo_spacing\";a:3:{s:11:\"padding-top\";s:4:\"17px\";s:14:\"padding-bottom\";s:4:\"17px\";s:5:\"units\";s:2:\"px\";}s:23:\"custom_admin_login_logo\";a:9:{s:3:\"url\";s:86:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/logo@2x.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:14:\"custom_favicon\";a:9:{s:3:\"url\";s:86:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/favicon.ico\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:11:\"iphone_icon\";a:9:{s:3:\"url\";s:91:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/apple-iphone.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:18:\"iphone_icon_retina\";a:9:{s:3:\"url\";s:98:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/apple-iphone-retina.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"ipad_icon\";a:9:{s:3:\"url\";s:89:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/apple-ipad.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"ipad_icon_retina\";a:9:{s:3:\"url\";s:96:\"https://data.imithemes.com/vestige/wp-content/themes/vestige/assets/images/apple-ipad-retina.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:13:\"enable-search\";s:1:\"0\";s:11:\"enable-cart\";s:1:\"0\";s:21:\"nav_directions_arrows\";s:1:\"1\";s:17:\"nav_items_spacing\";s:0:\"\";s:18:\"main_nav_link_typo\";a:8:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";}s:13:\"main_nav_link\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:14:\"main_nav_link2\";a:3:{s:7:\"regular\";s:7:\"#000000\";s:5:\"hover\";s:7:\"#4f723a\";s:6:\"active\";s:7:\"#000000\";}s:14:\"main_nav_link3\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:18:\"fw_menu_background\";a:1:{s:16:\"background-color\";s:0:\"\";}s:13:\"dd_background\";a:1:{s:16:\"background-color\";s:0:\"\";}s:9:\"dd_arrows\";s:1:\"1\";s:13:\"dd_dropshadow\";s:1:\"1\";s:16:\"dd_border_radius\";s:1:\"4\";s:14:\"dd_item_border\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:0:\"\";}s:19:\"dd_item_border_left\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:0:\"\";}s:15:\"dd_item_spacing\";a:5:{s:11:\"padding-top\";s:4:\"12px\";s:13:\"padding-right\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"12px\";s:12:\"padding-left\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:18:\"dd_item_background\";a:1:{s:16:\"background-color\";s:0:\"\";}s:17:\"dd_item_link_typo\";a:8:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";}s:18:\"dd_item_link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:13:\"mm_title_typo\";a:11:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:15:\"mm_content_typo\";a:11:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:13:\"mm_background\";a:1:{s:16:\"background-color\";s:0:\"\";}s:18:\"mm_item_link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:17:\"full_width_footer\";s:1:\"0\";s:13:\"footer_layout\";s:1:\"4\";s:10:\"tfooter_bg\";a:7:{s:16:\"background-color\";s:7:\"#7c9843\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:18:\"footer_top_spacing\";a:3:{s:11:\"padding-top\";s:4:\"50px\";s:14:\"padding-bottom\";s:4:\"50px\";s:5:\"units\";s:2:\"px\";}s:14:\"tfooter_border\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#4f723a\";}s:16:\"widgettitle_typo\";a:11:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:7:\"#000000\";}s:13:\"tfwidget_typo\";a:11:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:7:\"#000000\";}s:18:\"tfooter_link_color\";a:3:{s:7:\"regular\";s:7:\"#000000\";s:5:\"hover\";s:7:\"#4f723a\";s:6:\"active\";s:7:\"#000000\";}s:20:\"footer_bottom_enable\";s:1:\"1\";s:21:\"footer_copyright_text\";s:67:\"All Rights Reserved Museum Association of Newfoundland and Labrador\";s:10:\"bfooter_bg\";a:7:{s:16:\"background-color\";s:7:\"#4f723a\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:21:\"footer_bottom_spacing\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:14:\"bfooter_border\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#4f723a\";}s:13:\"bfwidget_typo\";a:11:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"bfooter_link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:19:\"footer_social_links\";a:23:{s:11:\"fa-facebook\";s:23:\"http://www.facebook.com\";s:10:\"fa-twitter\";s:22:\"http://www.twitter.com\";s:12:\"fa-pinterest\";s:0:\"\";s:14:\"fa-google-plus\";s:0:\"\";s:10:\"fa-youtube\";s:0:\"\";s:12:\"fa-instagram\";s:0:\"\";s:15:\"fa-vimeo-square\";s:0:\"\";s:6:\"fa-rss\";s:0:\"\";s:11:\"fa-dribbble\";s:0:\"\";s:10:\"fa-dropbox\";s:0:\"\";s:12:\"fa-bitbucket\";s:0:\"\";s:9:\"fa-flickr\";s:0:\"\";s:13:\"fa-foursquare\";s:0:\"\";s:9:\"fa-github\";s:0:\"\";s:9:\"fa-gittip\";s:0:\"\";s:11:\"fa-linkedin\";s:0:\"\";s:12:\"fa-pagelines\";s:0:\"\";s:8:\"fa-skype\";s:0:\"\";s:11:\"fa-envelope\";s:0:\"\";s:9:\"fa-tumblr\";s:0:\"\";s:14:\"fa-tripadvisor\";s:0:\"\";s:5:\"fa-vk\";s:0:\"\";s:7:\"fa-yelp\";s:0:\"\";}s:19:\"footer_bottom_icons\";a:2:{s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"28px\";}s:30:\"footer_bottom_icons_link_color\";a:3:{s:7:\"regular\";s:7:\"#666666\";s:5:\"hover\";s:7:\"#ffffff\";s:6:\"active\";s:0:\"\";}s:22:\"footer_bottom_icons_bg\";a:1:{s:16:\"background-color\";s:7:\"#eeeeee\";}s:29:\"footer_bottom_icons_dimension\";a:3:{s:5:\"width\";s:4:\"28px\";s:6:\"height\";s:4:\"28px\";s:5:\"units\";s:2:\"px\";}s:16:\"sidebar_position\";s:1:\"1\";s:13:\"posts_sidebar\";s:0:\"\";s:13:\"pages_sidebar\";s:0:\"\";s:14:\"events_sidebar\";s:0:\"\";s:19:\"exhibitions_sidebar\";s:0:\"\";s:12:\"team_sidebar\";s:0:\"\";s:16:\"artworks_sidebar\";s:0:\"\";s:13:\"venue_sidebar\";s:0:\"\";s:15:\"artists_sidebar\";s:0:\"\";s:18:\"event_term_sidebar\";s:0:\"\";s:23:\"exhibition_term_sidebar\";s:0:\"\";s:20:\"artwork_term_sidebar\";s:0:\"\";s:17:\"shop_term_sidebar\";s:0:\"\";s:14:\"search_sidebar\";s:0:\"\";s:17:\"sidebar_widget_bg\";a:1:{s:16:\"background-color\";s:0:\"\";}s:21:\"sidebar_widget_border\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:0:\"\";}s:19:\"sidebar_widget_text\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:20:\"sidebar_widget_links\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:23:\"sidebar_font_typography\";a:14:{s:11:\"font-family\";s:16:\"Roboto Condensed\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:4:\"left\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"20px\";s:11:\"line-height\";s:4:\"28px\";s:12:\"word-spacing\";s:3:\"0px\";s:14:\"letter-spacing\";s:3:\"2px\";s:5:\"color\";s:7:\"#222222\";}s:27:\"sidebar_widget_title_border\";a:6:{s:10:\"border-top\";s:0:\"\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:3:\"1px\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:0:\"\";}s:37:\"sidebar_widget_title_border_highlight\";s:0:\"\";s:16:\"theme_color_type\";s:1:\"1\";s:18:\"theme_color_scheme\";s:10:\"color1.css\";s:19:\"primary_theme_color\";s:7:\"#7c9843\";s:14:\"switch_sharing\";s:1:\"1\";s:13:\"sharing_style\";s:1:\"0\";s:13:\"sharing_color\";s:1:\"0\";s:10:\"share_icon\";a:9:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";i:4;s:0:\"\";i:5;s:1:\"1\";i:6;s:0:\"\";i:7;s:1:\"1\";i:8;s:1:\"1\";i:9;s:0:\"\";}s:16:\"share_post_types\";a:7:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";}s:18:\"facebook_share_alt\";s:17:\"Share on Facebook\";s:17:\"twitter_share_alt\";s:5:\"Tweet\";s:16:\"google_share_alt\";s:16:\"Share on Google+\";s:16:\"tumblr_share_alt\";s:14:\"Post to Tumblr\";s:19:\"pinterest_share_alt\";s:6:\"Pin it\";s:16:\"reddit_share_alt\";s:16:\"Submit to Reddit\";s:18:\"linkedin_share_alt\";s:17:\"Share on Linkedin\";s:15:\"email_share_alt\";s:5:\"Email\";s:12:\"vk_share_alt\";s:11:\"Share on vk\";s:15:\"share_show_text\";s:1:\"1\";s:20:\"share_icons_box_size\";a:3:{s:5:\"width\";s:4:\"28px\";s:6:\"height\";s:4:\"28px\";s:5:\"units\";s:2:\"px\";}s:21:\"share_icons_font_size\";a:2:{s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"28px\";}s:15:\"switch_lightbox\";s:1:\"1\";s:17:\"prettyphoto_theme\";s:10:\"pp_default\";s:19:\"prettyphoto_opacity\";s:3:\"0.5\";s:17:\"prettyphoto_title\";s:1:\"0\";s:14:\"venue-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:15:\"events-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"exhibitions-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"artists-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:17:\"artworks-bg-image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"events_archive_title\";s:6:\"Events\";s:18:\"blog_archive_title\";s:4:\"Blog\";s:25:\"exhibitions_archive_title\";s:11:\"Exhibitions\";s:18:\"team_archive_title\";s:4:\"Team\";s:18:\"shop_archive_title\";s:8:\"Products\";s:21:\"artwork_archive_title\";s:8:\"Artworks\";s:23:\"heading_font_typography\";a:5:{s:11:\"font-family\";s:33:\"\'Arial Black\', Gadget, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:20:\"body_font_typography\";a:5:{s:11:\"font-family\";s:28:\"Arial, Helvetica, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:22:\"button_font_typography\";a:5:{s:11:\"font-family\";s:33:\"\'Arial Black\', Gadget, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:18:\"h1_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h2_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h3_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h4_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h5_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:18:\"h6_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:27:\"body_unique_font_typography\";a:14:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:12:\"event_switch\";s:1:\"1\";s:12:\"event_tm_opt\";s:1:\"0\";s:12:\"event_dt_opt\";s:1:\"0\";s:16:\"event_show_until\";s:1:\"0\";s:15:\"exhibition_view\";s:1:\"0\";s:12:\"paypal_email\";s:0:\"\";s:12:\"paypal_token\";s:0:\"\";s:11:\"paypal_site\";s:1:\"1\";s:15:\"paypal_currency\";s:3:\"USD\";s:19:\"calendar_month_name\";s:85:\"January,February,March,April,May,June,July,August,September,October,November,December\";s:25:\"calendar_month_name_short\";s:47:\"Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec\";s:17:\"calendar_day_name\";s:56:\"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday\";s:23:\"calendar_day_name_short\";s:27:\"Sun,Mon,Tue,Wed,Thu,Fri,Sat\";s:11:\"event_feeds\";s:1:\"1\";s:15:\"google_feed_key\";s:0:\"\";s:14:\"google_feed_id\";s:0:\"\";s:19:\"event_default_color\";s:0:\"\";s:21:\"recurring_event_color\";s:0:\"\";s:14:\"google_map_api\";s:39:\"AIzaSyDLE_blMG8Zi38hvtZYLIXOeMzn8ZKpOlc\";s:10:\"custom_css\";s:466:\"body, blockquote {\r\n    color:#000!important;\r\n}\r\n.menu a {\r\n    color:#fff!important;\r\n}\r\n\r\n.sidebar .widget .menu a {\r\n    color:#000!important;\r\n}\r\n\r\n.swpm-forgot-pass-link {\r\n    display:none!important;\r\n}\r\n\r\n.swpm-join-us-link{\r\n    display:none!important;\r\n}\r\n\r\nmenu-footer-menu .menu {\r\ncolor:#fff!important;\r\n    \r\n}\r\n.topbar{\r\n    background:#485d29!important;\r\n    \r\n}\r\n.header-style2 .topbar .social-icons-colored li a {\r\n      color:#bdd849!important;\r\n}\";s:9:\"custom_js\";s:41:\"jQuery(document).ready(function(){\r\n\r\n});\";}", "yes");
INSERT INTO `manl_options` VALUES("169", "imic_options-transients", "a:3:{s:14:\"changed_values\";a:2:{s:10:\"share_icon\";a:9:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:1:\"1\";i:8;s:1:\"1\";i:9;s:0:\"\";}s:10:\"custom_css\";s:468:\"body, blockquote {\r\n    color:#000!important;\r\n}\r\n.menu a {\r\n    color:#fff!important;\r\n}\r\n\r\n.sidebar .widget .menu a {\r\n    color:#000!important;\r\n}\r\n\r\n.swpm-forgot-pass-link {\r\n    display:none!important;\r\n}\r\n\r\n.swpm-join-us-link{\r\n    display:none!important;\r\n}\r\n\r\nmenu-footer-menu .menu {\r\ncolor:#fff!important;\r\n    \r\n}\r\n.topbar{\r\n    background:#485d29!important;\r\n    \r\n}\r\n.header-style2 .topbar .social-icons-colored li a {\r\n      color:#bdd849!important;\r\n}\r\n\";}s:9:\"last_save\";i:1607465363;s:13:\"last_compiler\";i:1582127994;}", "yes");
INSERT INTO `manl_options` VALUES("170", "vestige_dynamic_css", "1", "yes");
INSERT INTO `manl_options` VALUES("171", "vestige_dynamic_fonts", "a:2:{s:6:\"family\";s:16:\"Roboto Condensed\";s:6:\"subset\";s:0:\"\";}", "yes");
INSERT INTO `manl_options` VALUES("172", "wbc_import_progress", "a:3:{s:10:\"total_post\";i:221;s:14:\"imported_count\";i:221;s:9:\"remaining\";i:0;}", "yes");
INSERT INTO `manl_options` VALUES("434", "testimonial-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("7021", "category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("435", "gallery-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("6383", "venue_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("437", "exhibition-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("438", "registrant-exhibition_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("1813", "event-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("440", "registrant-event_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("441", "team-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("442", "artwork-category_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("443", "artwork-artists_children", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("383", "siteorigin_panels_settings", "a:0:{}", "yes");
INSERT INTO `manl_options` VALUES("384", "siteorigin_panels_initial_version", "2.10.9", "no");
INSERT INTO `manl_options` VALUES("392", "widget_sow-button", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("393", "widget_sow-google-map", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("387", "siteorigin_panels_active_version", "2.11.8", "yes");
INSERT INTO `manl_options` VALUES("388", "widget_siteorigin-panels-post-content", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("389", "widget_siteorigin-panels-postloop", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("390", "widget_siteorigin-panels-builder", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("185", "siteorigin_widgets_active", "a:40:{s:6:\"button\";b:1;s:10:\"google-map\";b:1;s:5:\"image\";b:1;s:6:\"slider\";b:1;s:13:\"post-carousel\";b:1;s:6:\"editor\";b:1;s:16:\"so-button-widget\";b:1;s:20:\"so-google-map-widget\";b:1;s:15:\"so-image-widget\";b:1;s:16:\"so-slider-widget\";b:1;s:23:\"so-post-carousel-widget\";b:1;s:16:\"so-editor-widget\";b:1;s:14:\"counter-widget\";b:1;s:12:\"alert-widget\";b:1;s:21:\"featured-block-widget\";b:1;s:18:\"progressbar-widget\";b:1;s:13:\"spacer-widget\";b:1;s:11:\"tabs-widget\";b:1;s:13:\"toggle-widget\";b:1;s:15:\"carousel-widget\";b:1;s:19:\"skewed-title-widget\";b:1;s:13:\"venues-widget\";b:1;s:17:\"posts-list-widget\";b:1;s:19:\"testimonials-widget\";b:1;s:14:\"iconbox-widget\";b:1;s:11:\"team-widget\";b:1;s:9:\"hr-widget\";b:1;s:23:\"custom-grid-list-widget\";b:1;s:19:\"gallery-grid-widget\";b:1;s:18:\"events-list-widget\";b:1;s:23:\"exhibitions-list-widget\";b:1;s:22:\"upcoming-events-widget\";b:1;s:27:\"upcoming-exhibitions-widget\";b:1;s:3:\"cta\";b:1;s:20:\"social-media-buttons\";b:0;s:8:\"features\";b:1;s:4:\"hero\";b:1;s:5:\"video\";b:1;s:20:\"artworks-list-widget\";b:1;s:14:\"artists-widget\";b:1;}", "yes");
INSERT INTO `manl_options` VALUES("186", "wbc_imported_demos", "a:1:{s:12:\"wbc-import-1\";a:8:{s:9:\"directory\";s:7:\"classic\";s:8:\"imported\";s:8:\"imported\";s:12:\"content_file\";s:11:\"content.xml\";s:5:\"image\";s:16:\"screen-image.jpg\";s:13:\"theme_options\";s:17:\"theme-options.txt\";s:7:\"widgets\";s:12:\"widgets.json\";s:7:\"preview\";s:38:\"https://demo.imithemes.com/vestige-wp/\";s:7:\"display\";s:12:\"Classic Demo\";}}", "yes");
INSERT INTO `manl_options` VALUES("190", "wpforms_version", "1.5.4.2", "yes");
INSERT INTO `manl_options` VALUES("191", "wpforms_activated", "a:1:{s:4:\"lite\";i:1566910477;}", "yes");
INSERT INTO `manl_options` VALUES("213", "revslider-addons", "O:8:\"stdClass\":29:{s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:25:\"Display images in 360Â°\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"2.2.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"2.1.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:6:\"6.2.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:75:\"//updates.themepunch.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}}", "yes");
INSERT INTO `manl_options` VALUES("194", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("195", "_amn_wpforms-lite_to_check", "1581905473", "yes");
INSERT INTO `manl_options` VALUES("197", "wpforms_review", "a:2:{s:4:\"time\";i:1568680150;s:9:\"dismissed\";b:1;}", "yes");
INSERT INTO `manl_options` VALUES("199", "widget_bcn_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `manl_options` VALUES("206", "revslider_server_refresh", "1609821999", "yes");
INSERT INTO `manl_options` VALUES("207", "revslider-update-check-short", "1610870409", "yes");
INSERT INTO `manl_options` VALUES("208", "revslider-connection", "1", "yes");
INSERT INTO `manl_options` VALUES("209", "revslider-update-hash", "eecffbfb5f154d32bf7c1274e670776d", "yes");
INSERT INTO `manl_options` VALUES("210", "revslider-latest-version", "6.3.5", "yes");
INSERT INTO `manl_options` VALUES("211", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `manl_options` VALUES("212", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":8:{s:7:\"version\";s:5:\"6.3.2\";s:4:\"text\";s:370:\"<div style=\"display: block; background-color: #1C0950; text-align: \ncenter;\"><a \nhref=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=Admin%20Banner&utm_medium=banner&utm_campaign=wp56\"\n target=\"_blank\"><img alt=\"Important Notice\" src=\"//updates.themepunch.tools/banners/wordpress_56.jpg\" width=\"960\" height=\"250\" style=\"margin-bottom: -5px;\"></a></div>\";s:4:\"code\";s:11:\"TPRSWP56-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `manl_options` VALUES("201", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.3.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1566910483;s:7:\"version\";s:5:\"5.1.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `manl_options` VALUES("205", "revslider_servers", "a:7:{i:0;s:16:\"themepunch.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:22:\"themepunch-ext-b.tools\";}", "yes");
INSERT INTO `manl_options` VALUES("214", "revslider-library-check", "1609884615", "yes");
INSERT INTO `manl_options` VALUES("215", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `manl_options` VALUES("216", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"23