<?php

class ControllerExtensionModuleOutofstock extends Controller
{
    public function getProducts() { 

        $this->load->model('extension/module/outofstock');

        $products = [];

        $status = $this->config->get('module_outofstock_status');

        if($status){
            $products['outofstock_btntext'] = $this->config->get('module_outofstock_btntext');
            $products['outofstock_btncolor'] = $this->config->get('module_outofstock_btncolor');
            $products['outofstock_btntextcolor'] = $this->config->get('module_outofstock_btntextcolor');
            $products['products'] = $this->model_extension_module_outofstock->getProducts();
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($products));
    } 


    public function postViewHeader(&$route, &$data, &$output){
       
        $status = $this->config->get('module_outofstock_status');

        if($status){
            $style = '<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/outofstock.css" /> 
                    </head>';
            $output = str_replace('</head>', $style, $output);
                
        }
    } 

    public function postViewFooter(&$route, &$data, &$output){
        
        $status = $this->config->get('module_outofstock_status');

        if($status){
            $script = '<script type="text/javascript" src="catalog/view/javascript/outofstock.js"> </script>
                </body>';
            $output = str_replace('</body>', $script, $output);
                
        }
    }   
}